/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import org.apache.commons.httpclient.cookie.RFC2109Spec;

public abstract class CookiePolicy {
    private static final String SYSTEM_PROPERTY = "apache.commons.httpclient.cookiespec";
    public static final int COMPATIBILITY = 0;
    public static final int NETSCAPE_DRAFT = 1;
    public static final int RFC2109 = 2;
    private static int DefaultPolicy = 2;

    static {
        String s = System.getProperty(SYSTEM_PROPERTY);
        if (s != null) {
            if (s.equalsIgnoreCase("COMPATIBILITY")) {
                CookiePolicy.setDefaultPolicy(0);
            } else if (s.equalsIgnoreCase("NETSCAPE_DRAFT")) {
                CookiePolicy.setDefaultPolicy(1);
            } else {
                s.equalsIgnoreCase("RFC2109");
            }
            CookiePolicy.setDefaultPolicy(2);
        }
    }

    public static int getDefaultPolicy() {
        return DefaultPolicy;
    }

    public static void setDefaultPolicy(int policy) {
        DefaultPolicy = policy;
    }

    public static CookieSpec getSpecByPolicy(int policy) {
        switch (policy) {
            case 0: {
                return new CookieSpecBase();
            }
            case 1: {
                return new NetscapeDraftSpec();
            }
            case 2: {
                return new RFC2109Spec();
            }
        }
        return new RFC2109Spec();
    }

    public static CookieSpec getDefaultSpec() {
        return CookiePolicy.getSpecByPolicy(DefaultPolicy);
    }

    public static CookieSpec getSpecByVersion(int ver) {
        switch (ver) {
            case 0: {
                return new NetscapeDraftSpec();
            }
            case 1: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getCompatibilitySpec() {
        return CookiePolicy.getSpecByPolicy(0);
    }
}

