/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClient {
    private static final Log log;
    private HttpState state;
    private long httpConnectionTimeout = 0L;
    private int timeoutInMilliseconds = 0;
    private int connectionTimeout = 0;
    private HostConfiguration hostConfiguration;
    private boolean strictMode = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.HttpClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public HttpClient() {
        this(new SimpleHttpConnectionManager());
    }

    public HttpClient(HttpConnectionManager httpConnectionManager) {
        if (httpConnectionManager == null) {
            throw new IllegalArgumentException("httpConnectionManager cannot be null");
        }
        this.state = new HttpState();
        this.state.setHttpConnectionManager(httpConnectionManager);
        this.hostConfiguration = new HostConfiguration();
    }

    public synchronized HttpState getState() {
        return this.state;
    }

    public synchronized void setState(HttpState state) {
        this.state = state;
    }

    public synchronized void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public synchronized boolean isStrictMode() {
        return this.strictMode;
    }

    public synchronized void setTimeout(int newTimeoutInMilliseconds) {
        this.timeoutInMilliseconds = newTimeoutInMilliseconds;
    }

    public synchronized void setHttpConnectionFactoryTimeout(long timeout) {
        this.httpConnectionTimeout = timeout;
    }

    public synchronized void setConnectionTimeout(int newTimeoutInMilliseconds) {
        this.connectionTimeout = newTimeoutInMilliseconds;
    }

    public void startSession(String host, int port) {
        log.trace((Object)"enter HttpClient.startSession(String, int)");
        this.startSession(host, port, false);
    }

    public void startSession(String host, int port, boolean https) {
        log.trace((Object)"enter HttpClient.startSession(String, int, boolean)");
        if (log.isDebugEnabled()) {
            log.debug((Object)("HttpClient.startSession(String,int,boolean): Host:" + host + " Port:" + port + " HTTPS:" + https));
        }
        this.hostConfiguration.setHost(host, port, https ? "https" : "http");
    }

    public void startSession(String host, int port, Credentials creds) {
        log.trace((Object)"enter HttpClient.startSession(String, int, Credentials)");
        this.startSession(host, port, creds, false);
    }

    public void startSession(String host, int port, Credentials creds, boolean https) {
        log.trace((Object)"enter HttpClient.startSession(String, int, Credentials, boolean)");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting HttpClient session Host:" + host + " Port:" + port + " Credentials:" + creds + " HTTPS:" + https));
        }
        this.getState().setCredentials(null, creds);
        this.hostConfiguration.setHost(host, port, https ? "https" : "http");
    }

    public void startSession(URI uri) throws URIException {
        String host;
        log.trace((Object)"enter HttpClient.startSession(URI)");
        String scheme = uri.getScheme();
        if (scheme == null) {
            log.error((Object)"no scheme to start a session");
            throw new IllegalStateException("no scheme to start a session");
        }
        Protocol protocol = Protocol.getProtocol(scheme);
        String userinfo = uri.getUserinfo();
        if (userinfo != null) {
            this.getState().setCredentials(null, new UsernamePasswordCredentials(userinfo));
        }
        if ((host = uri.getHost()) == null || host.length() == 0) {
            log.error((Object)"no host to start a session");
            throw new IllegalStateException("no host to start a session");
        }
        int port = uri.getPort();
        if (port == -1) {
            log.error((Object)"HttpURL or HttpsURL instance required");
            throw new IllegalStateException("HttpURL or HttpsURL instance required");
        }
        this.hostConfiguration.setHost(host, port, protocol);
    }

    public void startSession(URL url) {
        log.trace((Object)"enter HttpClient.startSession(String, int, Credentials, boolean)");
        int port = url.getPort();
        Protocol protocol = Protocol.getProtocol(url.getProtocol());
        this.hostConfiguration.setHost(url.getHost(), port, protocol);
    }

    public void startSession(URL url, Credentials creds) {
        log.trace((Object)"enter HttpClient.startSession(URL, Credentials)");
        this.getState().setCredentials(null, creds);
        this.startSession(url);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport) {
        log.trace((Object)"enter HttpClient.startSession(String, int, String, int)");
        this.startSession(host, port, proxyhost, proxyport, false);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport, boolean secure) {
        log.trace((Object)"enter HttpClient.startSession(String, int, String, int, boolean)");
        this.hostConfiguration.setHost(host, port, secure ? "https" : "http");
        this.hostConfiguration.setProxy(proxyhost, proxyport);
    }

    public int executeMethod(HttpMethod method) throws IOException, HttpException {
        log.trace((Object)"enter HttpClient.executeMethod(HttpMethod)");
        return this.executeMethod(method.getHostConfiguration() != null ? method.getHostConfiguration() : this.getHostConfiguration(), method);
    }

    public int executeMethod(HostConfiguration hostConfiguration, HttpMethod method) throws IOException, HttpException {
        log.trace((Object)"enter HttpClient.executeMethod(HostConfiguration,HttpMethod)");
        if (method == null) {
            throw new NullPointerException("HttpMethod parameter");
        }
        int soTimeout = 0;
        boolean strictMode = false;
        int connectionTimeout = 0;
        long httpConnectionTimeout = 0L;
        HttpState state = null;
        HostConfiguration defaultHostConfiguration = null;
        HttpClient httpClient = this;
        synchronized (httpClient) {
            soTimeout = this.timeoutInMilliseconds;
            strictMode = this.strictMode;
            connectionTimeout = this.connectionTimeout;
            httpConnectionTimeout = this.httpConnectionTimeout;
            state = this.getState();
            defaultHostConfiguration = this.getHostConfiguration();
        }
        HostConfiguration methodConfiguration = new HostConfiguration(hostConfiguration);
        if (hostConfiguration != defaultHostConfiguration) {
            if (!methodConfiguration.isHostSet()) {
                methodConfiguration.setHost(defaultHostConfiguration.getHost(), defaultHostConfiguration.getPort(), defaultHostConfiguration.getProtocol());
            }
            if (!methodConfiguration.isProxySet() && defaultHostConfiguration.isProxySet()) {
                methodConfiguration.setProxy(defaultHostConfiguration.getProxyHost(), defaultHostConfiguration.getProxyPort());
            }
        }
        HttpConnection connection = state.getHttpConnectionManager().getConnection(methodConfiguration, httpConnectionTimeout);
        method.setStrictMode(strictMode);
        if (!connection.isOpen()) {
            connection.setSoTimeout(soTimeout);
            connection.setConnectionTimeout(connectionTimeout);
            connection.open();
            if (connection.isProxied() && connection.isSecure()) {
                method = new ConnectMethod(method);
            }
        }
        return method.execute(state, connection);
    }

    public void endSession() throws IOException {
    }

    public String getHost() {
        return this.hostConfiguration.getHost();
    }

    public int getPort() {
        return this.hostConfiguration.getPort();
    }

    public synchronized HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public synchronized void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
    }
}

