package monalipse.server;

import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchWindow;

public interface IBBSServer
{
	public String getTargetName();

	public void initialize(IFolder folder);
	public IFolder getServerFolder();
	public void createServerFolder(IWorkbenchWindow workbenchWindow, IProgressMonitor monitor);

	public IBoardTreeNode getBoardTree();
	public IBBSBoard getBoardOf(URL url);

	public boolean boardListChanged(IResourceChangeEvent event);
	public void updateBoardList(IWorkbenchWindow workbenchWindow);
	public URL getURLOf(IFile file);
}
