/*
 * Decompiled with CFR 0.152.
 */
package monalipse.bookmark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import monalipse.MonalipsePlugin;
import monalipse.bookmark.IBookmarkTreeNode;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSReference;
import monalipse.server.IThreadContentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.PluginTransferData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BookmarkManager {
    private static final Logger logger = MonalipsePlugin.getLogger();
    private static Transformer transformer;
    private static IBookmarkTreeNode bookmark;
    private static long timestamp;
    static /* synthetic */ Class class$0;

    public static IBookmarkTreeNode getBookmarks() {
        IProject project = MonalipsePlugin.getProject();
        if (project == null) {
            return new NullBookmarkTreeNode();
        }
        IFile file = project.getFile("bookmarks.xml");
        try {
            MonalipsePlugin.ensureSynchronized(file);
        }
        catch (CoreException coreException) {}
        if (file.exists() && timestamp != file.getModificationStamp()) {
            bookmark = null;
            timestamp = file.getModificationStamp();
        }
        if (bookmark != null) {
            return bookmark;
        }
        try {
            if (file.exists()) {
                logger.finest("load bookmarks.xml");
                DOMResult dom = new DOMResult();
                BookmarkManager.getTransformer().transform(new StreamSource(file.getContents()), dom);
                bookmark = XMLBookmarkTreeNode.of(((Document)dom.getNode()).getDocumentElement());
                if (bookmark != null) {
                    return bookmark;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("folder");
            root.setAttribute("name", "<root>");
            doc.appendChild(root);
            bookmark = XMLBookmarkTreeNode.of(root);
            if (bookmark != null) {
                return bookmark;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        bookmark = new NullBookmarkTreeNode();
        return bookmark;
    }

    public static void setBookmarks(IWorkbenchWindow workbenchWindow, IBookmarkTreeNode bookmark) {
        if (!(bookmark instanceof XMLBookmarkTreeNode)) {
            return;
        }
        final IProject project = MonalipsePlugin.getProject();
        if (project == null) {
            return;
        }
        BookmarkManager.bookmark = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BookmarkManager.getTransformer().transform(new DOMSource(((XMLBookmarkTreeNode)bookmark).getDocument()), new StreamResult(bout));
            bout.close();
            final byte[] bytes = bout.toByteArray();
            MonalipsePlugin.asyncExec(workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        logger.finest("save bookmarks.xml");
                        IFile file = project.getFile("bookmarks.xml");
                        MonalipsePlugin.ensureSynchronized(file);
                        if (file.exists()) {
                            file.setContents((InputStream)new ByteArrayInputStream(bytes), false, true, monitor);
                        } else {
                            file.create((InputStream)new ByteArrayInputStream(bytes), false, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static IBookmarkTreeNode[] getBookmarks(PluginTransferData data) {
        String string = data.getExtensionId();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.bookmark.IBookmarkTreeNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!string.equals(clazz.getName())) {
            return null;
        }
        try {
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(data.getData()));
            IBookmarkTreeNode[] nodes = new IBookmarkTreeNode[din.readInt()];
            IBookmarkTreeNode root = BookmarkManager.getBookmarks();
            int i = 0;
            while (i < nodes.length) {
                int pos;
                IBookmarkTreeNode select = root;
                while ((pos = din.readInt()) != -1) {
                    IBookmarkTreeNode[] ch = select.getChildren();
                    if (pos >= 0 && pos < ch.length) {
                        select = ch[pos];
                        continue;
                    }
                    return null;
                }
                nodes[i] = select;
                ++i;
            }
            return nodes;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static PluginTransferData getTransferData(IBookmarkTreeNode[] nodes) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeInt(nodes.length);
            int i = 0;
            while (i < nodes.length) {
                if (!BookmarkManager.writeIndexes(dout, nodes[i])) {
                    return null;
                }
                dout.writeInt(-1);
                ++i;
            }
            dout.close();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.bookmark.IBookmarkTreeNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new PluginTransferData(clazz.getName(), bout.toByteArray());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static boolean writeIndexes(DataOutputStream dout, IBookmarkTreeNode node) throws IOException {
        if (node.getParent() != null) {
            if (BookmarkManager.writeIndexes(dout, node.getParent())) {
                IBookmarkTreeNode[] nodes = node.getParent().getChildren();
                int i = 0;
                while (i < nodes.length) {
                    if (nodes[i] == node) {
                        dout.writeInt(i);
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean bookmarkChanged(IResourceChangeEvent event) {
        IProject project = MonalipsePlugin.getProject();
        if (project == null) {
            return false;
        }
        return MonalipsePlugin.resourceModified(7, event.getDelta(), (IResource)project.getFile("bookmarks.xml"));
    }

    public static IBookmarkTreeNode[] getChangedNodes(IBookmarkTreeNode root, IResourceChangeEvent event) {
        HashMap bookmarkedResources = new HashMap();
        BookmarkManager.getBookmarkedResources(root, bookmarkedResources);
        ArrayList list = new ArrayList();
        BookmarkManager.nodeModified(7, event.getDelta(), root, bookmarkedResources, MonalipsePlugin.getProject(), list);
        if (list.size() == 0) {
            return null;
        }
        IBookmarkTreeNode[] nodes = new IBookmarkTreeNode[list.size()];
        list.toArray(nodes);
        return nodes;
    }

    private static void getBookmarkedResources(IBookmarkTreeNode node, Map resourceMap) {
        if (node.hasChildren()) {
            IBookmarkTreeNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                BookmarkManager.getBookmarkedResources(children[i], resourceMap);
                ++i;
            }
        } else if (node instanceof IBBSReference) {
            URL url = ((IBBSReference)((Object)node)).getURL();
            IThreadContentProvider thread = BBSServerManager.getThreadContentProviderOf(url);
            if (thread != null) {
                BookmarkManager.addNodeMap(resourceMap, thread.getURL().toExternalForm(), node);
                BookmarkManager.addNodeMap(resourceMap, thread.getBoard().getURL().toExternalForm(), node);
            } else {
                IBBSBoard board = BBSServerManager.getBoardOf(url);
                if (board != null) {
                    BookmarkManager.addNodeMap(resourceMap, board.getURL().toExternalForm(), node);
                }
            }
        }
    }

    private static void addNodeMap(Map map, String key, IBookmarkTreeNode node) {
        List<IBookmarkTreeNode> list;
        if (map.containsKey(key)) {
            list = (List)map.get(key);
        } else {
            list = new ArrayList();
            map.put(key, list);
        }
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
    }

    private static void nodeModified(int type, IResourceDelta delta, IBookmarkTreeNode root, Map bookmarkedResources, IProject project, List resultNodes) {
        if (project == null) {
            return;
        }
        if (delta != null) {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(type);
            int i = 0;
            while (i < affectedChildren.length) {
                List nodeList;
                URL url;
                IResource res = affectedChildren[i].getResource();
                if (res instanceof IFile && res.getProject().equals((Object)project) && (url = BBSServerManager.getURLOf((IFile)res)) != null && (nodeList = (List)bookmarkedResources.get(url.toExternalForm())) != null) {
                    resultNodes.addAll(nodeList);
                }
                BookmarkManager.nodeModified(type, affectedChildren[i], root, bookmarkedResources, project, resultNodes);
                ++i;
            }
        }
    }

    private static Transformer getTransformer() throws TransformerException {
        if (transformer == null) {
            TransformerFactory tf = TransformerFactory.newInstance();
            transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", ResourcesPlugin.getEncoding());
        }
        return transformer;
    }

    private static class XMLBookmarkTreeLeaf
    extends XMLBookmarkTreeNode
    implements IBBSReference {
        XMLBookmarkTreeLeaf(Element element, String name, URL url) {
            super(element, name, url);
        }

        public boolean hasNewResponses() {
            IThreadContentProvider thread = BBSServerManager.getThreadContentProviderOf(this.getURL());
            return thread != null && thread.hasNewResponses();
        }

        public int getResponseNumber() {
            return -1;
        }
    }

    private static class XMLBookmarkTreeNode
    implements IBookmarkTreeNode {
        private Element element;
        private XMLBookmarkTreeNode parent;
        private String name;
        private boolean folder;
        private List children;
        private URL url;

        XMLBookmarkTreeNode(Element element, String name, List children) {
            this.element = element;
            this.name = name;
            this.children = new ArrayList(children);
            this.folder = true;
            int i = 0;
            while (i < children.size()) {
                ((XMLBookmarkTreeNode)children.get((int)i)).parent = this;
                ++i;
            }
        }

        XMLBookmarkTreeNode(Element element, String name, URL url) {
            this.element = element;
            this.name = name;
            this.url = url;
            this.folder = false;
        }

        public static XMLBookmarkTreeNode of(Element element) {
            if (element.getTagName().equals("folder") && element.getAttribute("name") != null) {
                NodeList nodes = element.getChildNodes();
                ArrayList<XMLBookmarkTreeNode> list = new ArrayList<XMLBookmarkTreeNode>();
                ArrayList<Node> removal = new ArrayList<Node>();
                int i = 0;
                while (i < nodes.getLength()) {
                    if (nodes.item(i) instanceof Element) {
                        XMLBookmarkTreeNode node = XMLBookmarkTreeNode.of((Element)nodes.item(i));
                        if (node != null) {
                            list.add(node);
                        }
                    } else if (nodes.item(i) instanceof Text) {
                        removal.add(nodes.item(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < removal.size()) {
                    element.removeChild((Node)removal.get(i));
                    ++i;
                }
                return new XMLBookmarkTreeNode(element, element.getAttribute("name"), list);
            }
            if (element.getTagName().equals("link") && element.getAttribute("name") != null && element.getAttribute("href") != null) {
                try {
                    return new XMLBookmarkTreeLeaf(element, element.getAttribute("name"), new URL(element.getAttribute("href")));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        private Document getDocument() {
            return this.element.getOwnerDocument();
        }

        public IBookmarkTreeNode[] getChildren() {
            if (this.children == null) {
                return new IBookmarkTreeNode[0];
            }
            IBookmarkTreeNode[] nodes = new IBookmarkTreeNode[this.children.size()];
            this.children.toArray(nodes);
            return nodes;
        }

        public String getName() {
            return this.name;
        }

        public IBookmarkTreeNode getParent() {
            return this.parent;
        }

        public IBookmarkTreeNode getRoot() {
            XMLBookmarkTreeNode root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            return root;
        }

        public boolean hasChildren() {
            return this.folder;
        }

        public URL getURL() {
            return this.url;
        }

        public IBookmarkTreeNode createFolder(String name, int location) {
            Element item = this.element.getOwnerDocument().createElement("folder");
            item.setAttribute("name", name);
            return this.insertItem(new XMLBookmarkTreeNode(item, name, new ArrayList()), location);
        }

        public IBookmarkTreeNode createLink(String name, URL href, int location) {
            Element item = this.element.getOwnerDocument().createElement("link");
            item.setAttribute("name", name);
            item.setAttribute("href", href.toExternalForm());
            return this.insertItem(new XMLBookmarkTreeNode(item, name, href), location);
        }

        private IBookmarkTreeNode insertItem(XMLBookmarkTreeNode item, int location) {
            switch (location) {
                case 1: {
                    this.element.getParentNode().insertBefore(item.element, this.element);
                    this.parent.children.add(this.parent.children.indexOf(this), item);
                    item.parent = this.parent;
                    break;
                }
                case 2: {
                    this.element.getParentNode().insertBefore(item.element, this.element.getNextSibling());
                    this.parent.children.add(this.parent.children.indexOf(this) + 1, item);
                    item.parent = this.parent;
                    break;
                }
                case 3: {
                    if (!this.hasChildren()) break;
                    this.element.appendChild(item.element);
                    this.children.add(item);
                    item.parent = this;
                }
            }
            return item;
        }

        public void setName(String name) {
            this.name = name;
            this.element.setAttribute("name", name);
        }

        public void remove() {
            this.element.getParentNode().removeChild(this.element);
            this.parent.children.remove(this);
        }

        public IBookmarkTreeNode findItem(URL url) {
            if (this.folder) {
                int i = 0;
                while (i < this.children.size()) {
                    IBookmarkTreeNode item = ((IBookmarkTreeNode)this.children.get(i)).findItem(url);
                    if (item != null) {
                        return item;
                    }
                    ++i;
                }
            } else if (this.url.toExternalForm().equals(url.toExternalForm())) {
                return this;
            }
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean isAncestorOf(IBookmarkTreeNode node) {
            while (node != null) {
                if (node == this) {
                    return true;
                }
                node = node.getParent();
            }
            return false;
        }

        public boolean hasNewResponses() {
            if (this.children != null) {
                int i = 0;
                while (i < this.children.size()) {
                    if (((IBookmarkTreeNode)this.children.get(i)).hasNewResponses()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    private static class NullBookmarkTreeNode
    implements IBookmarkTreeNode {
        NullBookmarkTreeNode() {
        }

        public IBookmarkTreeNode[] getChildren() {
            return new IBookmarkTreeNode[0];
        }

        public void setName(String name) {
        }

        public String getName() {
            return "";
        }

        public IBookmarkTreeNode getParent() {
            return null;
        }

        public IBookmarkTreeNode getRoot() {
            return null;
        }

        public boolean hasChildren() {
            return false;
        }

        public IBookmarkTreeNode createFolder(String name, int location) {
            return null;
        }

        public IBookmarkTreeNode createLink(String name, URL href, int location) {
            return null;
        }

        public void remove() {
        }

        public IBookmarkTreeNode findItem(URL url) {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean isAncestorOf(IBookmarkTreeNode node) {
            return false;
        }

        public boolean hasNewResponses() {
            return false;
        }
    }
}

