/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilePart
extends Part {
    private static final Log log;
    static int MAX_BUFF_SIZE;
    private String name;
    private PartSource source;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.methods.multipart.FilePart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        MAX_BUFF_SIZE = 0x100000;
    }

    public FilePart(String name, File file) throws FileNotFoundException {
        this(name, new FilePartSource(file));
    }

    public FilePart(String name, String fileName, File file) throws FileNotFoundException {
        this(name, new FilePartSource(fileName, file));
    }

    public FilePart(String name, PartSource partSource) {
        if (partSource.getLength() < 0L) {
            throw new InvalidParameterException("fileLength must be >= 0.");
        }
        this.name = name;
        this.source = partSource;
    }

    protected void sendHeader(OutputStream out) throws IOException {
        log.trace((Object)"enter sendHeader(OutputStream out)");
        super.sendHeader(out);
        this.sendFilename(out);
        this.sendContentType(out);
    }

    protected void sendFilename(OutputStream out) throws IOException {
        log.trace((Object)"enter sendFilename(OutputStream out)");
        String filename = "; filename=\"" + this.source.getFileName() + "\"";
        out.write(filename.getBytes());
    }

    protected void sendContentType(OutputStream out) throws IOException {
        log.trace((Object)"enter sendContentType(OutputStream out)");
        out.write(Part.CRLF_bytes);
        out.write("Content-Type: application/octet-stream".getBytes());
    }

    public String getName() {
        return this.name;
    }

    protected void sendData(OutputStream out) throws IOException {
        int len;
        log.trace((Object)"enter sendData(OutputStream out)");
        if (this.lengthOfData() == 0L) {
            log.debug((Object)"No data to send.");
            return;
        }
        byte[] buff = this.lengthOfData() > (long)MAX_BUFF_SIZE ? new byte[MAX_BUFF_SIZE] : new byte[new Long(this.lengthOfData()).intValue()];
        InputStream is = this.source.createInputStream();
        while ((len = is.read(buff)) != -1) {
            out.write(buff, 0, len);
        }
    }

    protected long lengthOfData() throws IOException {
        return this.source.getLength();
    }
}

