/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostMethod
extends GetMethod {
    public static final int CONTENT_LENGTH_AUTO = -2;
    public static final int CONTENT_LENGTH_CHUNKED = -1;
    private static final Log log;
    static final Header CONTENT_TYPE;
    protected ByteArrayOutputStream buffer = null;
    protected InputStream requestBody = null;
    protected Vector parameters = new Vector();
    protected int repeatCount = 0;
    protected int requestContentLength = -2;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.methods.PostMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        CONTENT_TYPE = new Header("Content-Type", "application/x-www-form-urlencoded");
    }

    public PostMethod() {
        this.setFollowRedirects(false);
    }

    public PostMethod(String path) {
        super(path);
        this.setFollowRedirects(false);
    }

    public PostMethod(String path, String tempDir) {
        super(path, tempDir);
        this.setFollowRedirects(false);
    }

    public PostMethod(String path, String tempDir, String tempFile) {
        super(path, tempDir, tempFile);
        this.setFollowRedirects(false);
    }

    public boolean getFollowRedirects() {
        if (!super.getFollowRedirects()) {
            return false;
        }
        return this.buffer != null;
    }

    public String getName() {
        return "POST";
    }

    public void setParameter(String parameterName, String parameterValue) {
        log.trace((Object)"enter PostMethod.setParameter(String, String)");
        if (this.requestBody != null) {
            throw new IllegalStateException("Request body already generated.");
        }
        this.removeParameter(parameterName, parameterValue);
        this.addParameter(parameterName, parameterValue);
    }

    public NameValuePair getParameter(String paramName) {
        log.trace((Object)"enter PostMethod.getParameter(String)");
        if (paramName == null) {
            return null;
        }
        Iterator iter = ((AbstractList)this.parameters).iterator();
        while (iter.hasNext()) {
            NameValuePair parameter = (NameValuePair)iter.next();
            if (!paramName.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public NameValuePair[] getParameters() {
        log.trace((Object)"enter PostMethod.getParameters()");
        int numPairs = this.parameters.size();
        Object[] objectArr = this.parameters.toArray();
        NameValuePair[] nvPairArr = new NameValuePair[numPairs];
        int i = 0;
        while (i < numPairs) {
            nvPairArr[i] = (NameValuePair)objectArr[i];
            ++i;
        }
        return nvPairArr;
    }

    public void setRequestBody(String body) {
        log.trace((Object)"enter PostMethod.setRequestBody(String)");
        if (!this.parameters.isEmpty()) {
            throw new IllegalStateException("Request parameters have already been added.");
        }
        if (body == null) {
            this.requestBody = null;
            return;
        }
        byte[] tmp = null;
        try {
            tmp = body.getBytes(this.getRequestCharSet());
        }
        catch (UnsupportedEncodingException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported request body charset: " + e.getMessage()));
            }
            tmp = body.getBytes();
        }
        this.requestBody = new ByteArrayInputStream(tmp);
    }

    public void setRequestBody(InputStream body) {
        log.trace((Object)"enter PostMethod.getRequestBody(InputStream)");
        if (!this.parameters.isEmpty()) {
            throw new IllegalStateException("Request parameters have already been added.");
        }
        this.requestBody = body;
    }

    public InputStream getRequestBody() {
        log.trace((Object)"enter PostMethod.getRequestBody()");
        if (this.requestBody != null) {
            return this.requestBody;
        }
        if (!this.parameters.isEmpty()) {
            return PostMethod.generateRequestBody(this.parameters, this.getRequestCharSet());
        }
        return null;
    }

    public String getRequestBodyAsString() throws IOException {
        log.trace((Object)"enter PostMethod.getRequestBodyAsString()");
        StringBuffer buffer = new StringBuffer();
        InputStream requestBody = this.getRequestBody();
        int data = requestBody.read();
        while (data != -1) {
            buffer.append((char)data);
            data = requestBody.read();
        }
        return buffer.toString();
    }

    public void setRequestContentLength(int length) {
        log.trace((Object)"enter PostMethod.setRequestContentLength(int)");
        if (length == -1 && !this.isHttp11()) {
            throw new RuntimeException("Chunked transfer encoding not allowed for HTTP/1.0");
        }
        this.requestContentLength = length;
    }

    public void addParameter(String paramName, String paramValue) {
        log.trace((Object)"enter PostMethod.addParameter(String, String)");
        if (this.requestBody != null) {
            throw new IllegalStateException("Request body already generated.");
        }
        if (paramName == null || paramValue == null) {
            throw new IllegalArgumentException("Arguments to addParameter(String, String) cannot be null");
        }
        this.parameters.add(new NameValuePair(paramName, paramValue));
    }

    public void addParameter(NameValuePair param) {
        log.trace((Object)"enter PostMethod.addParameter(NameValuePair)");
        if (this.requestBody != null) {
            throw new IllegalStateException("Request body already generated.");
        }
        if (param == null) {
            throw new IllegalArgumentException("Argument to addParameter(NameValuePair) cannot be null");
        }
        this.addParameter(param.getName(), param.getValue());
    }

    public void addParameters(NameValuePair[] parameters) {
        log.trace((Object)"enter PostMethod.addParameters(NameValuePair[])");
        if (this.requestBody != null) {
            throw new IllegalStateException("Request body already generated.");
        }
        if (parameters == null) {
            log.warn((Object)"Attempt to addParameters(null) ignored");
        } else {
            int i = 0;
            while (i < parameters.length) {
                this.addParameter(parameters[i]);
                ++i;
            }
        }
    }

    public void recycle() {
        log.trace((Object)"enter PostMethod.recycle()");
        super.recycle();
        this.requestBody = null;
        this.requestContentLength = -2;
        this.buffer = null;
        this.parameters.clear();
    }

    public boolean removeParameter(String paramName) {
        log.trace((Object)"enter PostMethod.removeParameter(String)");
        if (this.requestBody != null) {
            throw new IllegalStateException("Request body already generated.");
        }
        if (paramName == null) {
            throw new IllegalArgumentException("Argument passed to removeParameter(String) cannot be null");
        }
        boolean removed = true;
        Iterator iter = ((AbstractList)this.parameters).iterator();
        while (iter.hasNext()) {
            NameValuePair pair = (NameValuePair)iter.next();
            if (!paramName.equals(pair.getName())) continue;
            iter.remove();
            removed = true;
        }
        return removed;
    }

    public boolean removeParameter(String paramName, String paramValue) {
        log.trace((Object)"enter PostMethod.removeParameter(String, String)");
        if (this.requestBody != null) {
            throw new IllegalStateException("Request body already generated.");
        }
        if (paramName == null || paramValue == null) {
            throw new IllegalArgumentException("Argument passed to removeParameter(String,String) cannot be null");
        }
        Iterator iter = ((AbstractList)this.parameters).iterator();
        while (iter.hasNext()) {
            NameValuePair pair = (NameValuePair)iter.next();
            if (!paramName.equals(pair.getName()) || !paramValue.equals(pair.getValue())) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    protected int getRequestContentLength() {
        log.trace((Object)"enter PostMethod.getRequestContentLength()");
        if (this.requestBody == null) {
            this.requestBody = PostMethod.generateRequestBody(this.parameters, this.getRequestCharSet());
            this.bufferContent();
        }
        if (this.requestContentLength != -2) {
            return this.requestContentLength;
        }
        this.bufferContent();
        return this.requestContentLength;
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (!this.parameters.isEmpty()) {
            this.setRequestHeader(CONTENT_TYPE);
        }
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter PostMethod.writeRequestBody(HttpState, HttpConnection)");
        if (this.requestBody == null) {
            this.requestBody = PostMethod.generateRequestBody(this.parameters, this.getRequestCharSet());
        }
        if (this.repeatCount > 0 && this.buffer == null) {
            throw new HttpException("Sorry, unbuffered POST request can not be repeated.");
        }
        ++this.repeatCount;
        InputStream instream = this.requestBody;
        OutputStream outstream = conn.getRequestOutputStream();
        if (this.requestContentLength == -1) {
            outstream = new ChunkedOutputStream(outstream);
        }
        if (this.requestContentLength >= 0) {
            instream = new ContentLengthInputStream(instream, this.requestContentLength);
        }
        byte[] tmp = new byte[4096];
        int total = 0;
        int i = 0;
        while ((i = instream.read(tmp)) >= 0) {
            outstream.write(tmp, 0, i);
            total += i;
        }
        if (this.requestContentLength > 0 && total < this.requestContentLength) {
            throw new IOException("Unexpected end of input stream after " + total + " bytes (expected " + this.requestContentLength + " bytes)");
        }
        if (this.buffer != null) {
            this.requestBody = new ByteArrayInputStream(this.buffer.toByteArray());
        }
        return true;
    }

    static InputStream generateRequestBody(List params, String charSet) {
        log.trace((Object)"enter PostMethod.generateRequestBody(List)");
        Iterator it = params.iterator();
        StringBuffer buff = new StringBuffer();
        while (it.hasNext()) {
            NameValuePair parameter = (NameValuePair)it.next();
            String queryName = null;
            try {
                queryName = URIUtil.encodeWithinQuery(parameter.getName(), charSet);
            }
            catch (URIException urie) {
                log.error((Object)"encoding error within query name", (Throwable)urie);
                queryName = parameter.getName();
            }
            buff.append(queryName).append("=");
            String queryValue = null;
            try {
                queryValue = URIUtil.encodeWithinQuery(parameter.getValue(), charSet);
            }
            catch (URIException urie) {
                log.error((Object)"encoding error within query value", (Throwable)urie);
                queryValue = parameter.getValue();
            }
            buff.append(queryValue);
            if (!it.hasNext()) continue;
            buff.append("&");
        }
        return new ByteArrayInputStream(buff.toString().getBytes());
    }

    private void bufferContent() {
        log.trace((Object)"enter PostMethod.bufferContent()");
        if (this.buffer != null) {
            return;
        }
        try {
            this.buffer = new ByteArrayOutputStream();
            byte[] data = new byte[10000];
            int l = this.requestBody.read(data);
            int total = 0;
            while (l > 0) {
                this.buffer.write(data, 0, l);
                total += l;
                l = this.requestBody.read(data);
            }
            this.requestBody = new ByteArrayInputStream(this.buffer.toByteArray());
            this.requestContentLength = total;
        }
        catch (IOException e) {
            this.requestBody = null;
            this.requestContentLength = 0;
        }
    }
}

