/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.net.MalformedURLException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;

public class SimpleHttpConnectionManager
implements HttpConnectionManager {
    private HttpConnection httpConnection;

    public HttpConnection getConnection(HostConfiguration hostConfiguration) throws MalformedURLException {
        return this.getConnection(hostConfiguration, 0L);
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) throws MalformedURLException {
        String protocol = hostConfiguration.getProtocol();
        String host = hostConfiguration.getHost();
        int port = hostConfiguration.getPort();
        boolean isSecure = protocol.equalsIgnoreCase("HTTPS");
        if (this.httpConnection == null) {
            this.httpConnection = hostConfiguration.isProxySet() ? new HttpConnection(hostConfiguration.getProxyHost(), hostConfiguration.getProxyPort(), host, port, isSecure) : new HttpConnection(host, port, isSecure);
        } else if (!hostConfiguration.hostEquals(this.httpConnection) || !hostConfiguration.proxyEquals(this.httpConnection)) {
            if (this.httpConnection.isOpen()) {
                this.httpConnection.close();
            }
            this.httpConnection.setHost(host);
            this.httpConnection.setPort(port);
            this.httpConnection.setSecure(isSecure);
            this.httpConnection.setProxyHost(hostConfiguration.getProxyHost());
            this.httpConnection.setProxyPort(hostConfiguration.getProxyPort());
        }
        return this.httpConnection;
    }

    public void releaseConnection(HttpConnection conn) {
    }
}

