/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestOutputStream
extends OutputStream {
    private static final Log log;
    private static final Log wireLog;
    private boolean closed = false;
    private OutputStream stream = null;
    private boolean useChunking = false;
    private boolean writingChunk = false;
    private static final byte[] ENDCHUNK;
    private static final byte[] CRLF;
    private static final byte[] ZERO;
    private static final byte[] ONE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.RequestOutputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        wireLog = LogFactory.getLog((String)"httpclient.wire");
        ENDCHUNK = new byte[]{13, 10};
        CRLF = new byte[]{13, 10};
        ZERO = new byte[]{48};
        ONE = new byte[]{49};
    }

    public RequestOutputStream(OutputStream stream) {
        this(stream, false);
    }

    public RequestOutputStream(OutputStream stream, boolean useChunking) {
        if (stream == null) {
            throw new NullPointerException("stream parameter is null");
        }
        this.stream = stream;
        this.useChunking = useChunking;
    }

    public void setUseChunking(boolean useChunking) {
        this.useChunking = useChunking;
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public void print(String s) throws IOException {
        log.trace((Object)"enter RequestOutputStream.print(String)");
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.write(s.charAt(i));
            ++i;
        }
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void write(int b) throws IOException {
        if (this.useChunking) {
            this.stream.write(ONE, 0, ONE.length);
            this.stream.write(CRLF, 0, CRLF.length);
            this.stream.write(b);
            this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
            if (wireLog.isDebugEnabled()) {
                wireLog.debug((Object)">> byte 1 \\r\\n (chunk length \"header\")");
                wireLog.debug((Object)(">> byte " + b + "\\r\\n (chunked byte)"));
            }
        } else {
            this.stream.write(b);
            if (wireLog.isDebugEnabled()) {
                wireLog.debug((Object)(">> byte " + b));
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        log.trace((Object)"enter RequestOutputStream.write(byte[], int, int)");
        if (this.useChunking) {
            byte[] chunkHeader = (String.valueOf(Integer.toHexString(len)) + "\r\n").getBytes();
            this.stream.write(chunkHeader, 0, chunkHeader.length);
            this.stream.write(b, off, len);
            this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
            if (wireLog.isDebugEnabled()) {
                wireLog.debug((Object)(">> byte(s)" + len + " \\r\\n (chunk length " + "\"header\")"));
                wireLog.debug((Object)(">> \"" + new String(b, off, len) + "\"\\r\\n (chunked bytes)"));
            }
        } else {
            this.stream.write(b, off, len);
            if (wireLog.isDebugEnabled() && len > 0) {
                wireLog.debug((Object)(">> \"" + new String(b, off, len) + "\""));
            }
        }
    }

    public void close() throws IOException {
        block6: {
            log.trace((Object)"enter RequestOutputStream.close()");
            if (this.closed) break block6;
            try {
                try {
                    if (this.useChunking) {
                        this.stream.write(ZERO, 0, ZERO.length);
                        this.stream.write(CRLF, 0, CRLF.length);
                        this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
                        wireLog.debug((Object)">> byte 0 \\r\\n\\r\\n (final chunk)");
                    }
                }
                catch (IOException ioe) {
                    log.debug((Object)"Unexpected exception caught when closing output  stream", (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.closed = true;
                super.close();
                throw throwable;
            }
            Object var2_4 = null;
            this.closed = true;
            super.close();
        }
    }
}

