/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiThreadedHttpConnectionManager
implements HttpConnectionManager {
    private static final Log log;
    private Map mapHosts = new HashMap();
    private int maxConnections = 2;
    private Map referenceToHostPort = Collections.synchronizedMap(new HashMap());
    private ReferenceQueue referenceQueue = new ReferenceQueue();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.MultiThreadedHttpConnectionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public MultiThreadedHttpConnectionManager() {
        new ReferenceQueueThread().start();
    }

    public void setMaxConnectionsPerHost(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnections;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) throws MalformedURLException {
        while (true) {
            try {
                return this.getConnection(hostConfiguration, 0L);
            }
            catch (HttpException e) {
                log.debug((Object)"Unexpected exception while waiting for connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private static int getPort(String protocol, int port) {
        log.trace((Object)"HttpConnectionManager.getPort(String, port)");
        int portForProtocol = port;
        if (portForProtocol == -1) {
            portForProtocol = protocol.equalsIgnoreCase("HTTPS") ? 443 : 80;
        }
        return portForProtocol;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) throws HttpException, MalformedURLException {
        log.trace((Object)"enter HttpConnectionManager.getConnection(HostConfiguration, long)");
        if (hostConfiguration == null) {
            throw new MalformedURLException("hostConfiguration is null");
        }
        String protocol = hostConfiguration.getProtocol();
        String host = hostConfiguration.getHost();
        int port = MultiThreadedHttpConnectionManager.getPort(protocol, hostConfiguration.getPort());
        String hostAndPort = String.valueOf(host) + ":" + port;
        if (log.isDebugEnabled()) {
            log.debug((Object)("HttpConnectionManager.getConnection:  key = " + hostAndPort));
        }
        HostConnectionPool connectionPool = this.getConnectionPool(hostAndPort);
        HttpConnection conn = this.getConnection(connectionPool, host, port, protocol.equalsIgnoreCase("HTTPS"), hostConfiguration.getProxyHost(), hostConfiguration.getProxyPort(), timeout);
        return conn;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpConnection getConnection(HostConnectionPool connectionPool, String host, int port, boolean useHttps, String proxyHost, int proxyPort, long timeout) throws HttpException {
        connection = null;
        var10_9 = connectionPool;
        synchronized (var10_9) {
            while (true) lbl-1000:
            // 4 sources

            {
                if (connection != null) {
                    return connection;
                }
                if (connectionPool.freeConnections.size() > 0) {
                    connection = (HttpConnection)connectionPool.freeConnections.removeFirst();
                    continue;
                }
                if (connectionPool.numConnections < this.maxConnections) {
                    connection = new HttpConnection(proxyHost, proxyPort, host, port, useHttps);
                    connection.setHttpConnectionManager(this);
                    ++connectionPool.numConnections;
                    this.referenceToHostPort.put(new WeakReference<HttpConnection>(connection, this.referenceQueue), String.valueOf(host) + ":" + port);
                    continue;
                }
                threadTimeout = new TimeoutThread();
                threadTimeout.setTimeout(timeout);
                threadTimeout.setWakeupThread(Thread.currentThread());
                threadTimeout.start();
                try {
                    MultiThreadedHttpConnectionManager.log.debug((Object)("HttpConnectionManager.getConnection:  waiting for connection from " + connectionPool));
                    connectionPool.wait();
                    threadTimeout.interrupt();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new HttpException("Timeout waiting for connection.");
                }
                break;
            }
            {
                ** while (true)
            }
        }
    }

    private HostConnectionPool getConnectionPool(String hostAndPort) {
        log.trace((Object)"enter HttpConnectionManager.getConnections(String)");
        HostConnectionPool listConnections = null;
        Map map = this.mapHosts;
        synchronized (map) {
            listConnections = (HostConnectionPool)this.mapHosts.get(hostAndPort);
            if (listConnections == null) {
                listConnections = new HostConnectionPool();
                this.mapHosts.put(hostAndPort, listConnections);
            }
        }
        return listConnections;
    }

    public int getConnectionsInUse(String hostAndPort) {
        HostConnectionPool connectionPool;
        log.trace((Object)"enter HttpConnectionManager.getConnectionsInUse(String)");
        HostConnectionPool hostConnectionPool = connectionPool = this.getConnectionPool(hostAndPort);
        synchronized (hostConnectionPool) {
            return connectionPool.numConnections;
        }
    }

    public void releaseConnection(HttpConnection conn) {
        HostConnectionPool listConnections;
        log.trace((Object)"enter HttpConnectionManager.releaseConnection(HttpConnection)");
        String host = conn.getHost();
        int port = conn.getPort();
        String key = String.valueOf(host) + ":" + port;
        if (log.isDebugEnabled()) {
            log.debug((Object)("HttpConnectionManager.releaseConnection:  Release connection for " + host + ":" + port));
        }
        HostConnectionPool hostConnectionPool = listConnections = this.getConnectionPool(key);
        synchronized (hostConnectionPool) {
            listConnections.freeConnections.addFirst(conn);
            if (listConnections.numConnections == 0) {
                log.error((Object)("connection pool not found for host: " + key));
                listConnections.numConnections = 1;
            }
            listConnections.notify();
        }
    }

    private class HostConnectionPool {
        public LinkedList freeConnections = new LinkedList();
        public int numConnections = 0;

        HostConnectionPool() {
        }
    }

    private class ReferenceQueueThread
    extends Thread {
        public ReferenceQueueThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    HostConnectionPool connectionPool;
                    Reference ref = MultiThreadedHttpConnectionManager.this.referenceQueue.remove();
                    if (ref == null) continue;
                    String hostPort = (String)MultiThreadedHttpConnectionManager.this.referenceToHostPort.get(ref);
                    MultiThreadedHttpConnectionManager.this.referenceToHostPort.remove(ref);
                    HostConnectionPool hostConnectionPool = connectionPool = MultiThreadedHttpConnectionManager.this.getConnectionPool(hostPort);
                    synchronized (hostConnectionPool) {
                        --connectionPool.numConnections;
                        connectionPool.notify();
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    log.debug((Object)"ReferenceQueueThread interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private static class TimeoutThread
    extends Thread {
        private long timeout = 0L;
        private Thread thrdWakeup = null;

        TimeoutThread() {
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setWakeupThread(Thread thrdWakeup) {
            this.thrdWakeup = thrdWakeup;
        }

        public Thread getWakeupThread() {
            return this.thrdWakeup;
        }

        public void run() {
            log.trace((Object)"TimeoutThread.run()");
            if (this.timeout == 0L) {
                return;
            }
            if (this.thrdWakeup == null) {
                return;
            }
            try {
                Thread.sleep(this.timeout);
                this.thrdWakeup.interrupt();
            }
            catch (InterruptedException e) {
                log.debug((Object)"InterruptedException caught as expected");
            }
        }
    }
}

