/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.util.TimeoutController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConnection {
    private static final Log log;
    private static final Log wireLog;
    private String _host = null;
    private int _port = -1;
    private String _proxyHost = null;
    private int _proxyPort = -1;
    private Socket _socket = null;
    private InputStream _input = null;
    private OutputStream _output = null;
    private boolean _open = false;
    private boolean _ssl = false;
    private static final byte[] CRLF;
    private int _so_timeout = 0;
    private SSLSocketFactory sslSocketFactory = null;
    private boolean _usingSecureSocket = false;
    private boolean _tunnelEstablished = false;
    private int connect_timeout = 0;
    private HttpConnectionManager httpConnectionManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.HttpConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        wireLog = LogFactory.getLog((String)"httpclient.wire");
        CRLF = "\r\n".getBytes();
    }

    public HttpConnection(String host, int port) {
        this(null, -1, host, port, false);
    }

    public HttpConnection(String host, int port, boolean secure) {
        this(null, -1, host, port, secure);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port) {
        this(proxyHost, proxyPort, host, port, false);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port, boolean secure) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HttpConnectionManager.getConnection:  creating  connection for " + host + ":" + port + " via " + proxyHost + ":" + proxyPort));
        }
        if (host == null) {
            throw new NullPointerException("host parameter is null");
        }
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._host = host;
        this._port = port;
        this._ssl = secure;
    }

    public void setSSLSocketFactory(SSLSocketFactory factory) {
        this.assertNotOpen();
        this.sslSocketFactory = factory;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) throws IllegalStateException {
        if (host == null) {
            throw new NullPointerException("host parameter is null");
        }
        this.assertNotOpen();
        this._host = host;
    }

    public int getPort() {
        if (this._port < 0) {
            return this.isSecure() ? 443 : 80;
        }
        return this._port;
    }

    public void setPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this._port = port;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public void setProxyHost(String host) throws IllegalStateException {
        this.assertNotOpen();
        this._proxyHost = host;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this._proxyPort = port;
    }

    public boolean isSecure() {
        return this._ssl;
    }

    public String getProtocol() {
        return this.isSecure() ? "HTTPS" : "HTTP";
    }

    public void setSecure(boolean secure) throws IllegalStateException {
        this.assertNotOpen();
        this._ssl = secure;
    }

    public boolean isOpen() {
        return this._open;
    }

    public boolean isProxied() {
        return this._proxyHost != null && this._proxyPort > 0;
    }

    public void setSoTimeout(int timeout) throws SocketException, IllegalStateException {
        log.debug((Object)("HttpConnection.setSoTimeout(" + timeout + ")"));
        this._so_timeout = timeout;
        if (this._socket != null) {
            this._socket.setSoTimeout(timeout);
        }
    }

    public void setConnectionTimeout(int timeout) {
        this.connect_timeout = timeout;
    }

    public void open() throws IOException {
        log.trace((Object)"enter HttpConnection.open()");
        this.assertNotOpen();
        try {
            if (this._socket == null) {
                int port;
                final String host = this._proxyHost == null ? this._host : this._proxyHost;
                int n = port = this._proxyHost == null ? this._port : this._proxyPort;
                if (this.isSecure() && !this.isProxied()) {
                    if (this.sslSocketFactory == null) {
                        this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    }
                    if (this.connect_timeout == 0) {
                        this._socket = new SocketCreator().createSocket(host, port);
                    } else {
                        SocketTask task = new SocketTask(){

                            public void doit() throws IOException {
                                this.s = new SocketCreator().createSocket(host, port);
                            }
                        };
                        TimeoutController.execute(task, (long)this.connect_timeout);
                        this._socket = task.s;
                        if (task.exception != null) {
                            throw task.exception;
                        }
                    }
                    this._usingSecureSocket = true;
                } else {
                    if (this.connect_timeout == 0) {
                        this._socket = new Socket(host, port);
                    } else {
                        SocketTask task = new SocketTask(this){

                            public void doit() throws IOException {
                                this.s = new Socket(host, port);
                            }
                        };
                        TimeoutController.execute(task, (long)this.connect_timeout);
                        this._socket = task.s;
                        if (task.exception != null) {
                            throw task.exception;
                        }
                    }
                    this._usingSecureSocket = false;
                }
            }
            this._socket.setSoTimeout(this._so_timeout);
            this._input = this._socket.getInputStream();
            this._output = this._socket.getOutputStream();
            this._open = true;
        }
        catch (IOException e) {
            this.closeSocketAndStreams();
            throw e;
        }
        catch (TimeoutController.TimeoutException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("The host " + this._host + ":" + this._port + " (or proxy " + this._proxyHost + ":" + this._proxyPort + ") did not accept the connection " + "within timeout of " + this.connect_timeout + " milliseconds"));
            }
            throw new ConnectionTimeoutException();
        }
    }

    public void tunnelCreated() throws IllegalStateException, IOException {
        log.trace((Object)"enter HttpConnection.tunnelCreated()");
        if (!this.isSecure() || !this.isProxied()) {
            throw new IllegalStateException("Connection must be secure and proxied to use this feature");
        }
        if (this._usingSecureSocket) {
            throw new IllegalStateException("Already using a secure socket");
        }
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        this._socket = new SocketCreator().createSocket(this._socket, this._host, this._port, true);
        this._input = this._socket.getInputStream();
        this._output = this._socket.getOutputStream();
        this._usingSecureSocket = true;
        this._tunnelEstablished = true;
        log.debug((Object)"Secure tunnel created");
    }

    public boolean isTransparent() {
        return !this.isProxied() || this._tunnelEstablished;
    }

    public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
        log.trace((Object)"enter HttpConnection.getRequestOutputStream()");
        this.assertOpen();
        return this._output;
    }

    public OutputStream getRequestOutputStream(boolean useChunking) throws IOException, IllegalStateException {
        log.trace((Object)"enter HttpConnection.getRequestOutputStream(boolean)");
        this.assertOpen();
        if (useChunking) {
            return new ChunkedOutputStream(this._output);
        }
        return this._output;
    }

    public InputStream getResponseInputStream(HttpMethod method) throws IOException, IllegalStateException {
        log.trace((Object)"enter HttpConnection.getResponseInputStream(HttpMethod)");
        return this.getResponseInputStream();
    }

    public InputStream getResponseInputStream() throws IOException, IllegalStateException {
        log.trace((Object)"enter HttpConnection.getResponseInputStream()");
        this.assertOpen();
        return this._input;
    }

    public void write(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
        log.trace((Object)"enter HttpConnection.write(byte[])");
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException, IllegalStateException, HttpRecoverableException {
        log.trace((Object)"enter HttpConnection.write(byte[], int, int)");
        if (offset + length > data.length) {
            throw new HttpRecoverableException("Unable to write: offset=" + offset + " length=" + length + " data.length=" + data.length);
        }
        if (data.length <= 0) {
            throw new HttpRecoverableException("Unable to write: data.length=" + data.length);
        }
        this.assertOpen();
        if (wireLog.isDebugEnabled()) {
            String data_str = new String(data, offset, length, "ISO-8859-1");
            wireLog.debug((Object)(">> \"" + data_str + "\" [\\r\\n]"));
        }
        try {
            this._output.write(data, offset, length);
        }
        catch (SocketException se) {
            log.debug((Object)"HttpConnection: Socket exception while writing data", (Throwable)se);
            throw new HttpRecoverableException(se.toString());
        }
        catch (IOException ioe) {
            log.debug((Object)"HttpConnection: Exception while writing data", (Throwable)ioe);
            throw ioe;
        }
    }

    public void writeLine(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
        log.trace((Object)"enter HttpConnection.writeLine(byte[])");
        this.assertOpen();
        if (wireLog.isDebugEnabled() && data.length > 0) {
            String data_str = new String(data);
            wireLog.debug((Object)(">> \"" + data_str.trim() + "\" [\\r\\n]"));
        }
        try {
            this._output.write(data);
            this.writeLine();
        }
        catch (SocketException se) {
            log.info((Object)"SocketException while writing data to output", (Throwable)se);
            throw new HttpRecoverableException(se.toString());
        }
        catch (IOException ioe) {
            log.info((Object)"IOException while writing data to output", (Throwable)ioe);
            throw ioe;
        }
    }

    public void writeLine() throws IOException, IllegalStateException, HttpRecoverableException {
        log.trace((Object)"enter HttpConnection.writeLine()");
        wireLog.debug((Object)">> [\\r\\n]");
        try {
            this._output.write(CRLF);
        }
        catch (SocketException se) {
            log.warn((Object)"HttpConnection: Socket exception while writing data", (Throwable)se);
            throw new HttpRecoverableException(se.toString());
        }
        catch (IOException ioe) {
            log.warn((Object)"HttpConnection: IO exception while writing data", (Throwable)ioe);
            throw ioe;
        }
    }

    public void print(String data) throws IOException, IllegalStateException, HttpRecoverableException {
        log.trace((Object)"enter HttpConnection.print(String)");
        this.write(data.getBytes());
    }

    public void printLine(String data) throws IOException, IllegalStateException, HttpRecoverableException {
        log.trace((Object)"enter HttpConnection.printLine(String)");
        this.writeLine(data.getBytes());
    }

    public void printLine() throws IOException, IllegalStateException, HttpRecoverableException {
        log.trace((Object)"enter HttpConnection.printLine()");
        this.writeLine();
    }

    public String readLine() throws IOException, IllegalStateException {
        log.trace((Object)"enter HttpConnection.readLine()");
        this.assertOpen();
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = this._input.read()) < 0) {
                if (buf.length() != 0) break;
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            buf.append((char)ch);
        }
        if (wireLog.isDebugEnabled() && buf.length() > 0) {
            wireLog.debug((Object)("<< \"" + buf.toString() + "\" [\\r\\n]"));
        }
        return buf.toString();
    }

    public void shutdownOutput() {
        log.trace((Object)"enter HttpConnection.shutdownOutput()");
        try {
            Class[] paramsClasses = new Class[]{};
            Method shutdownOutput = this._socket.getClass().getMethod("shutdownOutput", paramsClasses);
            Object[] params = new Object[]{};
            shutdownOutput.invoke((Object)this._socket, params);
        }
        catch (Exception ex) {
            log.debug((Object)"Unexpected Exception caught", (Throwable)ex);
        }
    }

    public void close() {
        log.trace((Object)"enter HttpConnection.close()");
        this.closeSocketAndStreams();
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public void releaseConnection() {
        log.trace((Object)"enter HttpConnection.releaseConnection()");
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.releaseConnection(this);
        }
    }

    protected void closeSocketAndStreams() {
        log.trace((Object)"enter HttpConnection.closeSockedAndStreams()");
        if (this._input != null) {
            try {
                this._input.close();
            }
            catch (Exception ex) {
                log.debug((Object)"Exception caught when closing input", (Throwable)ex);
            }
            this._input = null;
        }
        if (this._output != null) {
            try {
                this._output.close();
            }
            catch (Exception ex) {
                log.debug((Object)"Exception caught when closing output", (Throwable)ex);
            }
            this._output = null;
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Exception ex) {
                log.debug((Object)"Exception caught when closing socket", (Throwable)ex);
            }
            this._socket = null;
        }
        this._open = false;
        this._tunnelEstablished = false;
        this._usingSecureSocket = false;
    }

    protected void assertNotOpen() throws IllegalStateException {
        if (this._open) {
            throw new IllegalStateException("Connection is open");
        }
    }

    protected void assertOpen() throws IllegalStateException {
        if (!this._open) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    public class ConnectionTimeoutException
    extends IOException {
    }

    private abstract class SocketTask
    implements Runnable {
        public Socket s;
        public IOException exception;

        SocketTask() {
        }

        public abstract void doit() throws IOException;

        public void run() {
            try {
                this.doit();
            }
            catch (IOException e) {
                this.exception = e;
            }
        }
    }

    private class SocketCreator {
        SocketCreator() {
        }

        public Socket createSocket(Socket socket, String host, int port, boolean auto) throws IOException {
            return HttpConnection.this.sslSocketFactory.createSocket(socket, host, port, auto);
        }

        public Socket createSocket(String host, int port) throws IOException {
            return HttpConnection.this.sslSocketFactory.createSocket(host, port);
        }
    }
}

