/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.HttpConnection;

public class HostConfiguration
implements Cloneable {
    private String host;
    private int port;
    private String protocol;
    private boolean hostSet;
    private String proxyHost;
    private int proxyPort;
    private boolean proxySet;

    public HostConfiguration() {
        this.host = null;
        this.port = -1;
        this.protocol = null;
        this.hostSet = false;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.proxySet = false;
    }

    public HostConfiguration(HostConfiguration hostConfiguration) {
        HostConfiguration hostConfiguration2 = hostConfiguration;
        synchronized (hostConfiguration2) {
            this.host = hostConfiguration.getHost();
            this.port = hostConfiguration.getPort();
            this.protocol = hostConfiguration.getProtocol();
            this.hostSet = hostConfiguration.isHostSet();
            this.proxyHost = hostConfiguration.getProxyHost();
            this.proxyPort = hostConfiguration.getProxyPort();
            this.proxySet = hostConfiguration.isProxySet();
        }
    }

    public Object clone() {
        return new HostConfiguration(this);
    }

    public synchronized boolean hostEquals(HttpConnection connection) {
        if (this.hostSet) {
            return this.host.equalsIgnoreCase(connection.getHost()) && this.port == connection.getPort() && this.protocol.equalsIgnoreCase(connection.getProtocol());
        }
        return false;
    }

    public synchronized boolean proxyEquals(HttpConnection connection) {
        if (this.proxyHost == null) {
            return connection.getProxyHost() == null;
        }
        return this.proxyHost.equalsIgnoreCase(connection.getProxyHost()) && this.proxyPort == connection.getProxyPort();
    }

    public synchronized boolean isHostSet() {
        return this.hostSet;
    }

    public synchronized void setHost(String host, int port, String protocol) {
        if (host == null) {
            throw new IllegalArgumentException("host must not be null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol must not be null");
        }
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.hostSet = true;
    }

    public synchronized String getHostURL() {
        if (!this.hostSet) {
            throw new IllegalStateException("a default host must be set to create a host URL");
        }
        String url = String.valueOf(this.protocol) + "://" + this.host;
        if (this.port != -1) {
            url = String.valueOf(url) + ":" + this.port;
        }
        return url;
    }

    public synchronized String getHost() {
        return this.host;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized String getProtocol() {
        return this.protocol;
    }

    public synchronized boolean isProxySet() {
        return this.proxySet;
    }

    public synchronized void setProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxySet = true;
    }

    public synchronized String getProxyHost() {
        return this.proxyHost;
    }

    public synchronized int getProxyPort() {
        return this.proxyPort;
    }

    public boolean equals(Object o) {
        if (o instanceof HostConfiguration) {
            HostConfiguration config = (HostConfiguration)o;
            return this.proxyPort == config.getProxyPort() && (this.proxyHost == null ? config.getProxyHost() == null : this.proxyHost.equals(config.getProxyHost())) && this.getHostURL().equals(config.getHostURL());
        }
        return false;
    }
}

