package monalipse.server.giko;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

import monalipse.MonalipsePlugin;
import monalipse.server.AbstractBBSServer;
import monalipse.server.IBoardListContentProvider;
import monalipse.server.IThreadContentProvider;
import monalipse.server.IThreadListContentProvider;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchWindow;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebConversation;

public class GikoServer extends AbstractBBSServer
{
	public static final String PREF_BBSMENU_URL = "bbsmenu.url";
	public static final String DEFAULT_BBSMENU_URL = "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html";
	public static final String PREF_OYSTER_ID = "oyster.id";
	public static final String DEFAULT_OYSTER_ID = "";
	public static final String PREF_OYSTER_PASSWORD = "oyster.password";
	public static final String DEFAULT_OYSTER_PASSWORD = "";
	public static final String USER_AGENT;

	private static final long LOGIN_INTERVAL = 60 * 60 * 1000;

	private static final WebConversation wc = new WebConversation();
	private static String sessionID;
	private static long loginTime;
	
	static
	{
		HttpUnitOptions.setDefaultCharacterSet("Windows-31J");
		HttpUnitOptions.setAutoRedirect(false);
		HttpUnitOptions.setLoggingHttpHeaders(true);
		PluginVersionIdentifier versionID = Platform.getPluginRegistry().getPluginDescriptor(MonalipsePlugin.PLUGIN_ID).getVersionIdentifier();
		USER_AGENT = "monalipse/" + versionID;
		wc.setHeaderField("User-Agent", "Monazilla/1.00 (" + USER_AGENT + ")");
	}

	private IWorkbenchWindow workbenchWindow;
	private BoardListContentProvider boardListContentProvider;
	private ThreadListContentProvider threadListContentProvider;

	public IBoardListContentProvider getBoardListContentProvider()
	{
		return boardListContentProvider;
	}
	
	public void initialize(IWorkbenchWindow workbenchWindow, IProject project)
	{
		super.initialize(workbenchWindow, project);
		this.workbenchWindow = workbenchWindow;
		boardListContentProvider = new BoardListContentProvider(getWorkbenchWindow());
		threadListContentProvider = new ThreadListContentProvider(getWorkbenchWindow());
		IPreferenceStore pref = MonalipsePlugin.getDefault().getPreferenceStore();
		pref.setDefault(PREF_BBSMENU_URL, DEFAULT_BBSMENU_URL);
		pref.setDefault(PREF_OYSTER_ID, DEFAULT_OYSTER_ID);
		pref.setDefault(PREF_OYSTER_PASSWORD, DEFAULT_OYSTER_PASSWORD);
	}
	
	public String getTargetName()
	{
		return GikoServer.class.getName();
	}
	
	public IFolder getLogFolderOf(Object board)
	{
		if(board instanceof Board)
			return ((Board)board).getLogFolder();
		else
			return null;
	}

	public IThreadListContentProvider getThreadListContentProvider()
	{
		return threadListContentProvider;
	}
	
	public IThreadContentProvider getThreadContentProviderOf(String baseURL, IFolder logFolder, String id, String name)
	{
		return new ThreadContentProvider(workbenchWindow, baseURL, logFolder, id, 0, name, 0);
	}
	
	public IThreadContentProvider getThreadContentProviderOf(IProject project, URL url)
	{
		if(url.getProtocol().equals("http"))
		{
			String[] domains = BoardListContentProvider.BBS_DOMAINS;
			for(int i = 0; i < domains.length; i++)
			{
				if(url.getHost().endsWith(domains[i]))
				{
					String readCgi = "/test/read.cgi";
					String kako = "/kako/";
					String html = ".html";
					String bbs = "bbs=";
					String key = "key=";
					String dir = url.getFile();
					String baseURL = null;
					IFolder logFolder = null;
					String id = null;
					if(dir.startsWith(readCgi))
					{
						dir = dir.substring(readCgi.length(), dir.length());
						int s = dir.indexOf('/', 1);
						if(s == -1)
						{
							StringTokenizer tk = new StringTokenizer(dir, "?&");
							while(tk.hasMoreTokens())
							{
								String t = tk.nextToken().toLowerCase();
								if(t.indexOf(bbs) != -1)
								{
									baseURL = "http://" + url.getHost() + "/" + t.substring(t.indexOf(bbs) + bbs.length(), t.length()) + "/";
									logFolder = BoardListContentProvider.getLogFolderOf(project, baseURL);
								}
								else if(t.indexOf(key) != -1)
								{
									id = t.substring(t.indexOf(key) + key.length(), t.length()) + ".dat";
								}
							}
						}
						else
						{
							baseURL = "http://" + url.getHost() + dir.substring(0, s + 1);
							logFolder = BoardListContentProvider.getLogFolderOf(project, baseURL);
							int t = dir.indexOf('/', s + 1);
							if(t == -1)
								t = dir.length();
							id = dir.substring(s + 1, t) + ".dat";
						}
					}
					else if(dir.indexOf(kako) != -1 && dir.endsWith(html))
					{
						baseURL = "http://" + url.getHost() + dir.substring(0, dir.indexOf(kako) + 1);
						logFolder = BoardListContentProvider.getLogFolderOf(project, baseURL);
						int h = dir.indexOf(html);
						int t = dir.lastIndexOf('/', h);
						if(t == -1)
							return null;
						id = dir.substring(t + 1, h) + ".dat";
					}

					if(baseURL != null && logFolder != null && id != null)
						return getThreadContentProviderOf(baseURL, logFolder, id, "?");
				}
			}
		}
		return null;
	}
	
	public static WebConversation getWebConversation()
	{
		return wc;
	}

	public static void asyncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run)
	{
		workbenchWindow.getShell().getDisplay().asyncExec(new Runnable()
			{
				public void run()
				{
					try
					{
						workbenchWindow.run(false, false, run);
					}
					catch(InterruptedException e)
					{
						e.printStackTrace();
					}
					catch(InvocationTargetException e)
					{
						e.printStackTrace();
					}
				}
			});
	}

	public static void syncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run)
	{
		workbenchWindow.getShell().getDisplay().syncExec(new Runnable()
			{
				public void run()
				{
					try
					{
						workbenchWindow.run(false, false, run);
					}
					catch(InterruptedException e)
					{
						e.printStackTrace();
					}
					catch(InvocationTargetException e)
					{
						e.printStackTrace();
					}
				}
			});
	}

	public static String getOysterSessionID()
	{
		IPreferenceStore store = MonalipsePlugin.getDefault().getPreferenceStore();
		String id = store.getString(GikoServer.PREF_OYSTER_ID);
		String password = store.getString(GikoServer.PREF_OYSTER_PASSWORD);
		if(id.length() != 0 && password.length() != 0)
		{
			if(System.currentTimeMillis() - loginTime < LOGIN_INTERVAL)
				return sessionID;
			
			try
			{
				String body = "ID=" + id + "&PW=" + password;		
				URLConnection conn = new URL("https://tiger2.he.net/~tora3n2c/futen.cgi").openConnection();
				conn.setRequestProperty("User-Agent", "DOLIB/1.00");
				conn.setRequestProperty("X-2ch-UA", USER_AGENT);
				conn.setRequestProperty("Content-Length", String.valueOf(body.length()));
				conn.setDoInput(true);
				conn.setDoOutput(true);
				OutputStream out = conn.getOutputStream();
				out.write(body.getBytes());

				BufferedReader r = new BufferedReader(new InputStreamReader(conn.getInputStream()));
				try
				{
					String res = r.readLine();
					res = res.substring("SESSION-ID=".length(), res.length());
					String ua = res.substring(0, res.indexOf(':'));
					
					if(!ua.equals("ERROR"))
					{
						sessionID = res;
						wc.setHeaderField("User-Agent", ua + " (" + USER_AGENT + ")");
						loginTime = System.currentTimeMillis();
						return sessionID;
					}
				}
				finally
				{
					r.close();
				}
			}
			catch (MalformedURLException e)
			{
			}
			catch (IOException e)
			{
			}
		}
		return null;
	}

}
