package monalipse.server;

import java.io.Reader;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractBBSServer implements IBBSServer
{
	private IWorkbenchWindow workbenchWindow;
	private IProject project;

	public void initialize(IWorkbenchWindow workbenchWindow, IProject project)
	{
		this.workbenchWindow = workbenchWindow;
		this.project = project;
	}

	public IWorkbenchWindow getWorkbenchWindow()
	{
		return workbenchWindow;
	}

	public IProject getProject()
	{
		return project;
	}

	public static boolean resourceModified(int type, IResourceDelta delta, IResource target)
	{
		boolean res = false;

		if(delta != null)
		{
			IResourceDelta[] affectedChildren = delta.getAffectedChildren(type);
			for (int i = 0; i < affectedChildren.length; i++)
			{
				if(affectedChildren[i].getResource().equals(target))
					return true;
				res |= resourceModified(type, affectedChildren[i], target);
			}
		}

		return res;
	}

}
