package monalipse.part;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

class StatusLineProgressMonitorPart extends ProgressMonitorPart
{
	private SubStatusLineManager manager;
	private Display display;
	private IAction cancelAction;
	private ThreadGroup threads = new ThreadGroup(getClass().getName());
	private int runCount;

	public StatusLineProgressMonitorPart(Composite parent, SubStatusLineManager manager, IAction cancelAction)
	{
		super(parent, getFillGrid());
		this.manager = manager;
		this.cancelAction = cancelAction;
		display = parent.getShell().getDisplay();
	}
	
	public void dispose()
	{
		super.dispose();
	}
	
	private static Layout getFillGrid()
	{
		GridLayout grid = new GridLayout(2, false);
		grid.marginWidth = 0;
		grid.marginHeight = 0;
		grid.horizontalSpacing = 0;
		grid.verticalSpacing = 0;
		return grid;
	}
	
	public SubStatusLineManager getStatusLineManager()
	{
		return manager;
	}

	protected void initialize(Layout layout, int progressIndicatorHeight)
	{
		super.initialize(layout, progressIndicatorHeight);
		GridData gd = new GridData();
		gd.horizontalAlignment = gd.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.verticalAlignment = gd.FILL;
		gd.grabExcessVerticalSpace = true;
		fProgressIndicator.setLayoutData(gd);
	}
	
	public Thread run(final Object serializeKey, final IRunnableWithProgress run)
	{
		setCancelEnabled(true);
		return run(new Runnable()
			{
				public void run()
				{
					if(serializeKey == null)
					{
						runInternal();
					}
					else
					{
						synchronized(serializeKey)
						{
							runInternal();
						}
					}
				}

				public void runInternal()
				{
					runCount++;
					try
					{
						run.run(StatusLineProgressMonitorPart.this);
					}
					catch (InvocationTargetException e)
					{
						 e.printStackTrace();
					}
					catch (InterruptedException e)
					{
						 e.printStackTrace();
					}
					finally
					{
						runCount--;
						setCancelEnabled(runCount != 0);
					}
				}
			});
	}
	
	private Thread run(Runnable run)
	{
		Thread thread = new Thread(threads, run, getClass().getName());
		thread.start();
		return thread;
	}
	
	private void setCancelEnabled(final boolean enabled)
	{
		display.syncExec(new Runnable()
			{
				public void run()
				{
					if(enabled)
					{
						cancelAction.setEnabled(true);
						manager.setVisible(true);
					}
					else
					{
						manager.setVisible(false);
						cancelAction.setEnabled(false);
					}
					manager.update(true);
				}
			});
	}

	public void interruptAll()
	{
		synchronized(threads)
		{
			threads.interrupt();
		}
	}

	public void setTaskName(final String name)
	{
		display.syncExec(new Runnable()
			{
				public void run()
				{
					if(!isDisposed())
						manager.setMessage(name);
				}
			});
	}
	
	public void beginTask(final String name, final int totalWork)
	{
		display.syncExec(new Runnable()
			{
				public void run()
				{
					if(!isDisposed())
					{
						manager.setMessage(name);
						StatusLineProgressMonitorPart.super.beginTask("", totalWork);
					}
				}
			});
	}
	
	public void worked(final int work)
	{
		display.syncExec(new Runnable()
			{
				public void run()
				{
					if(!isDisposed())
						StatusLineProgressMonitorPart.super.worked(work);
				}
			});
	}
	
	public void done()
	{
		display.syncExec(new Runnable()
			{
				public void run()
				{
					if(!isDisposed())
						StatusLineProgressMonitorPart.super.done();
				}
			});
	}

}
