/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import monalipse.part.CancelableRunner;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSServer;
import monalipse.server.IBoardListContentProvider;
import monalipse.views.NullTreeContentProvider;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;

public class BoardListView
extends ViewPart
implements IResourceChangeListener {
    public static final String ID_BOARD_LIST;
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_LABEL = "label";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    private static final String TAG_FILTERS = "filters";
    private static final String TAG_FILTER = "filter";
    private TreeViewer viewer;
    private IBBSServer server;
    private IBoardListContentProvider provider;
    private CancelableRunner cancelable;
    private IAction reloadAction;
    private IAction abortAction;
    private IMemento memento;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.BoardListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_BOARD_LIST = clazz.getName();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        String target = this.getConfigurationElement().getAttribute("target");
        this.server = BBSServerManager.getInstanceOf(target, this.getSite().getWorkbenchWindow());
        this.viewer = new TreeViewer(parent, 772);
        this.setContent();
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
    }

    public IBBSServer getServer() {
        return this.server;
    }

    public String getBoardNameOf(Object board) {
        if (this.provider != null) {
            return this.provider.getText(board);
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.provider != null && this.provider.resourceChanged(event)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.views.BoardListView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)clazz.getName());
            this.saveState((IMemento)memento);
            this.viewer.setInput(this.viewer.getInput());
            this.restoreState((IMemento)memento);
        }
    }

    public void saveState(IMemento memento) {
        if (this.viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        this.saveExpansionState(memento);
        this.saveSelectionState(memento);
    }

    private void saveSelectionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_SELECTION), ((IStructuredSelection)this.viewer.getSelection()).toArray());
    }

    private void saveExpansionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_EXPANDED), this.viewer.getVisibleExpandedElements());
    }

    private void setElements(IMemento memento, Object[] elements) {
        if (this.provider == null) {
            return;
        }
        if (elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                Object o = elements[i];
                IMemento elementMem = memento.createChild(TAG_ELEMENT);
                while (this.provider.getParent(o) != null) {
                    IMemento labelMem = elementMem.createChild(TAG_LABEL);
                    labelMem.putString(TAG_LABEL, this.provider.getText(o));
                    o = this.provider.getParent(o);
                }
                ++i;
            }
        }
    }

    private void restoreState(IMemento memento) {
        this.restoreExpansionState(memento);
        this.restoreSelectionState(memento);
    }

    private void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(this.getElements(childMem)));
        }
    }

    private void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            this.viewer.setExpandedElements(this.getElements(childMem).toArray());
        }
    }

    private List getElements(IMemento memento) {
        ArrayList<Object> list = new ArrayList<Object>();
        IMemento[] elementMem = memento.getChildren(TAG_ELEMENT);
        int i = 0;
        while (i < elementMem.length) {
            IMemento[] labelMem = elementMem[i].getChildren(TAG_LABEL);
            Object[] children = this.provider.getElements(this.viewer.getInput());
            Object e = null;
            int j = labelMem.length - 1;
            while (j >= 0) {
                e = this.findElement(children, labelMem[j].getString(TAG_LABEL));
                if (e == null) break;
                children = this.provider.getChildren(e);
                --j;
            }
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    private Object findElement(Object[] list, String label) {
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (this.provider.getText(list[i]).equals(label)) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    private void setContent() {
        if (this.server == null) {
            this.provider = null;
            this.viewer.setContentProvider((IContentProvider)new NullTreeContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        } else {
            this.provider = this.server.getBoardListContentProvider();
            this.viewer.setContentProvider((IContentProvider)this.provider);
            this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
            this.viewer.setInput((Object)this.server.getProject());
            if (this.provider.getElements(this.viewer.getInput()).length == 0) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        BoardListView.this.getSite().getPage().activate((IWorkbenchPart)BoardListView.this);
                        BoardListView.this.reloadAction.run();
                    }
                });
            }
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BoardListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalStatuBar(bars.getStatusLineManager());
    }

    private void fillLocalStatuBar(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, this.getSite().getShell().getDisplay(), this.abortAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.abortAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.reloadAction = new Action(){

            public void run() {
                BoardListView.this.cancelable.run((Object)BoardListView.this.cancelable, new IRunnableWithProgress(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (BoardListView.access$3(3.access$0(this.this$1)) != null) {
                            BoardListView.access$3(3.access$0(this.this$1)).updateBoardList();
                        }
                    }
                });
            }

            static /* synthetic */ BoardListView access$0(3 var0) {
                return var0.BoardListView.this;
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload board list");
        try {
            this.reloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(){

            public void run() {
                BoardListView.this.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort downloading board list");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static /* synthetic */ IBoardListContentProvider access$3(BoardListView boardListView) {
        return boardListView.provider;
    }

    private class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

