/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import monalipse.MonalipsePlugin;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditor;
import monalipse.part.CancelableRunner;
import monalipse.server.BBSServerManager;
import monalipse.server.INewResponseLineFragment;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IResponseHeaderLine;
import monalipse.server.IThreadContentProvider;
import monalipse.server.IThreadToolTipProvider;
import monalipse.server.RendererResource;
import monalipse.server.giko.GikoServer;
import monalipse.server.giko.ThreadListFragment;
import monalipse.widgets.ColoredText;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.xml.sax.SAXException;

class ThreadContentProvider
implements IAdaptable,
IThreadContentProvider {
    private IWorkbenchWindow workbenchWindow;
    private ThreadListFragment fragment;
    private String baseURL;
    private String urlHint;
    private IFolder logFolder;
    private String id;
    private int index;
    private String name;
    private int responses;
    private static final PatternAction NUM_REF_PATTERN = new PatternAction(Pattern.compile("(>|\uff1e)+(([0-9\uff10-\uff19]+)(->*([0-9\uff10-\uff19]+))?)")){

        public String getLink(Matcher m) {
            String start = ThreadContentProvider.toASCIIDigits(m.group(3));
            String end = m.group(5);
            end = end == null ? start : ThreadContentProvider.toASCIIDigits(end);
            return "#" + start + "-" + end;
        }
    };
    private static final PatternAction NAME_NUM_REF_PATTERN = new PatternAction(Pattern.compile("[0-9\uff10-\uff19]+")){

        public String getLink(Matcher m) {
            String num = ThreadContentProvider.toASCIIDigits(m.group());
            return "#" + num + "-" + num;
        }

        public boolean next(Matcher m) {
            return m.matches();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction TRIP_DECL_PATTERN = new PatternAction(Pattern.compile("\u25c6([\\p{Alnum}\\./]{8,10})")){

        public String getLink(Matcher m) {
            return "trip:" + m.group(1);
        }

        public boolean next(Matcher m) {
            return m.find();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction URL_REF_PATTERN = new PatternAction(Pattern.compile("(((h?t)?t)?p)?(s?://[\\p{Alnum}\\.\\-_:]+(/[\\p{Alnum}!#%&'*+,-./:;=?@\\\\^_`\\|~]*)?)")){

        public String getLink(Matcher m) {
            return "http" + m.group(4);
        }
    };
    private static final PatternAction ID_DECL_PATTERN = new PatternAction(Pattern.compile("ID:(.{8})")){

        public String getLink(Matcher m) {
            return "id:" + m.group(1).trim();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction[] NAME_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN, NAME_NUM_REF_PATTERN, TRIP_DECL_PATTERN};
    private static final PatternAction[] MAIL_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN};
    private static final PatternAction[] DATE_PATTERN_SET = new PatternAction[]{ID_DECL_PATTERN};
    private static final PatternAction[] BODY_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN, URL_REF_PATTERN};

    public ThreadContentProvider(IWorkbenchWindow workbenchWindow, String baseURL, IFolder logFolder, String id, int index, String name, int responses) {
        this.workbenchWindow = workbenchWindow;
        this.baseURL = baseURL;
        this.logFolder = logFolder;
        this.id = id;
        this.index = index;
        this.name = name;
        this.responses = responses;
        int ss = baseURL.indexOf("//");
        if (ss != -1 && id.endsWith(".dat")) {
            int s = baseURL.indexOf(47, ss + 2);
            this.urlHint = String.valueOf(baseURL.substring(0, s)) + "/test/read.cgi" + baseURL.substring(s, baseURL.length()) + id.substring(0, id.length() - 4) + "/l50";
        }
    }

    public void setThreadListFragment(ThreadListFragment fragment) {
        this.fragment = fragment;
    }

    public ThreadListFragment getThreadListFragment() {
        return this.fragment;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getURLHint() {
        return this.urlHint;
    }

    public IFolder getLogFolder() {
        return this.logFolder;
    }

    public IFile getLogFile() {
        return this.logFolder.getFile(this.id);
    }

    public String getID() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getResponseCountHint() {
        return this.responses;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadContentProvider) {
            ThreadContentProvider thread = (ThreadContentProvider)obj;
            return thread.logFolder.equals((Object)this.logFolder) && thread.id.equals(this.id);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitResponse(CancelableRunner cancelable, String name, String mail, String body) {
        try {
            Object var13_15;
            BufferedReader r;
            block14: {
                block13: {
                    String l;
                    WebConversation wc = GikoServer.getWebConversation();
                    wc.addCookie("NAME", name);
                    wc.addCookie("MAIL", mail);
                    PostMethodWebRequest req = new PostMethodWebRequest(new URL(new URL(this.baseURL), "/test/bbs.cgi").toExternalForm());
                    req.setHeaderField("Referer", this.getURLHint());
                    String bbs = new URL(this.baseURL).getFile();
                    req.setParameter("submit", "\u66f8\u304d\u8fbc\u3080");
                    req.setParameter("bbs", bbs.substring(1, bbs.length() - 1));
                    req.setParameter("key", this.id.substring(0, this.id.lastIndexOf(46)));
                    req.setParameter("time", String.valueOf(System.currentTimeMillis() / 1000L));
                    req.setParameter("FROM", name);
                    req.setParameter("mail", mail);
                    req.setParameter("MESSAGE", body);
                    String sid = GikoServer.getOysterSessionID();
                    if (sid != null) {
                        req.setParameter("sid", sid);
                    }
                    boolean retry = false;
                    WebResponse resp = wc.getResponse(req);
                    r = new BufferedReader(new InputStreamReader(resp.getInputStream(), "Windows-31J"));
                    try {
                        while ((l = r.readLine()) != null) {
                            if (l.indexOf("\u66f8\u304d\u3053\u307f\u307e\u3057\u305f") != -1) {
                                Object var13_13 = null;
                                r.close();
                                return true;
                            }
                            if (l.indexOf("\u78ba\u8a8d") == -1) continue;
                            retry = true;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        r.close();
                        throw throwable;
                    }
                    var13_15 = null;
                    r.close();
                    if (!retry) return false;
                    resp = wc.getResponse(req);
                    r = new BufferedReader(new InputStreamReader(resp.getInputStream(), "Windows-31J"));
                    try {
                        while ((l = r.readLine()) != null) {
                            if (l.indexOf("\u66f8\u304d\u3053\u307f\u307e\u3057\u305f") == -1) continue;
                            var13_15 = null;
                            break block13;
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        var13_15 = null;
                        r.close();
                        throw throwable;
                    }
                }
                r.close();
                return true;
            }
            var13_15 = null;
            r.close();
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (SAXException sAXException) {}
        return false;
    }

    public IResponseEnumeration getResponses(int sequence, int rangeStart, RendererResource rendererResource) {
        LogFile log;
        block9: {
            log = null;
            try {
                boolean partial;
                IFile file = this.logFolder.getFile(this.id);
                MonalipsePlugin.ensureSynchronized(file);
                if (!file.exists() || (log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())))) == null) break block9;
                boolean bl = partial = log.sequence == sequence;
                if (partial) {
                    try {
                        if (log.responseCount < rangeStart) {
                            throw new IOException();
                        }
                        int i = 0;
                        while (i < rangeStart) {
                            log.skipResponse();
                            ++i;
                        }
                    }
                    catch (IOException iOException) {
                        log.close();
                        log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())));
                        return new ThreadLogReader(log.title, log, false, log.sequence, log.isActive, rendererResource);
                    }
                }
                return new ThreadLogReader(log.title, log, partial, log.sequence, log.isActive, rendererResource);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (log != null) {
            log.close();
        }
        return new NullResponseEnumeration("?", sequence);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResponseEnumeration updateResponses(CancelableRunner cancelable, int sequence, int rangeStart, RendererResource rendererResource) {
        IResponseEnumeration res;
        boolean notFound;
        String lastModified;
        IFile file;
        GetMethodWebRequest req;
        block20: {
            WebConversation wc = GikoServer.getWebConversation();
            req = new GetMethodWebRequest(String.valueOf(this.baseURL) + "dat/" + this.id);
            file = this.logFolder.getFile(this.id);
            lastModified = null;
            notFound = false;
            System.err.println("partial");
            try {
                LogFile log;
                block21: {
                    ArrayThreadReader arrayThreadReader;
                    block22: {
                        MonalipsePlugin.ensureSynchronized(file);
                        if (!file.exists()) break block20;
                        log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())));
                        try {
                            boolean partial;
                            if (log == null) break block21;
                            lastModified = log.lastModifierd;
                            boolean bl = partial = log.sequence == sequence;
                            if (!partial) break block21;
                            ArrayList logs = new ArrayList();
                            ArrayList lastResponse = null;
                            if (rangeStart <= log.responseCount) {
                                while (log.available()) {
                                    lastResponse = new ArrayList();
                                    log.readResponse(lastResponse, rendererResource);
                                    logs.add(lastResponse);
                                }
                            }
                            if (lastResponse == null) break block21;
                            req.setHeaderField("Range", "bytes=" + log.httpRangeStart + "-");
                            req.setHeaderField("If-Modified-Since", lastModified);
                            WebResponse wr = wc.getResponse(req);
                            if (wr.getResponseCode() == 206) {
                                RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(log.httpRangeStart, wr.getInputStream());
                                InputStreamReader r = new InputStreamReader((InputStream)cin, "Windows-31J");
                                int contentLength = Integer.parseInt(wr.getHeaderField("Content-Length"));
                                ArrayList lineReceiver = new ArrayList();
                                LogFile.parseResponse(r, lineReceiver, logs.size(), rendererResource);
                                if (this.equalResponse(lastResponse, lineReceiver)) {
                                    ThreadDownloader threadDownloader = new ThreadDownloader(log.title, cancelable, r, cin, true, log.sequence, wr.getHeaderField("Last-Modified"), logs, rangeStart, contentLength, file, true, rendererResource);
                                    Object var19_27 = null;
                                    if (log == null) return threadDownloader;
                                    log.close();
                                    return threadDownloader;
                                }
                                r.close();
                                break block21;
                            }
                            if (wr.getResponseCode() == 304) {
                                arrayThreadReader = new ArrayThreadReader(log.title, true, log.sequence, logs, rangeStart, true);
                                break block22;
                            }
                            if (wr.getResponseCode() == 404 || wr.getResponseCode() == 302) {
                                notFound = true;
                            }
                            break block21;
                        }
                        catch (Throwable throwable) {
                            Object var19_29 = null;
                            if (log == null) throw throwable;
                            log.close();
                            throw throwable;
                        }
                    }
                    Object var19_28 = null;
                    if (log == null) return arrayThreadReader;
                    log.close();
                    return arrayThreadReader;
                }
                Object var19_30 = null;
                if (log != null) {
                    log.close();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (HttpException e) {
                e.printStackTrace();
            }
        }
        ++sequence;
        System.err.println("full");
        if (!notFound) {
            req.removeHeaderField("Range");
            res = this.getResponse(req, lastModified, cancelable, sequence, file, false, true, rendererResource);
            if (res != null) {
                return res;
            }
        }
        req = 14 <= this.id.length() ? new GetMethodWebRequest(String.valueOf(this.baseURL) + "kako/" + this.id.substring(0, 4) + "/" + this.id.substring(0, 5) + "/" + this.id + ".gz") : (this.id.length() == 13 ? new GetMethodWebRequest(String.valueOf(this.baseURL) + "kako/" + this.id.substring(0, 3) + "/" + this.id + ".gz") : null);
        System.err.println("log " + req);
        if (req != null && (res = this.getResponse(req, lastModified, cancelable, sequence, file, false, false, rendererResource)) != null) {
            return res;
        }
        System.err.println("oyster ");
        String sid = GikoServer.getOysterSessionID();
        if (sid == null) return new NullResponseEnumeration("?", sequence);
        try {
            req = new GetMethodWebRequest(new URL(this.baseURL), "/test/offlaw.cgi");
            String bbs = new URL(this.baseURL).getFile();
            req.setParameter("bbs", bbs.substring(1, bbs.length() - 1));
            req.setParameter("key", this.id.substring(0, this.id.lastIndexOf(46)));
            req.setParameter("sid", sid);
            req.setParameter("raw", "0.0");
            IResponseEnumeration res2 = this.getResponse(req, lastModified, cancelable, sequence, file, true, false, rendererResource);
            if (res2 == null) return new NullResponseEnumeration("?", sequence);
            return res2;
        }
        catch (MalformedURLException malformedURLException) {}
        return new NullResponseEnumeration("?", sequence);
    }

    private boolean equalResponse(List resp1, List resp2) {
        if (resp1.size() != resp2.size()) {
            return false;
        }
        int i = 0;
        while (i < resp1.size()) {
            ColoredText.Line line1 = (ColoredText.Line)resp1.get(i);
            ColoredText.Line line2 = (ColoredText.Line)resp2.get(i);
            if (line1.getLineFragmentCount() != line2.getLineFragmentCount()) {
                return false;
            }
            int j = 0;
            while (j < line1.getLineFragmentCount()) {
                ColoredText.LineFragment frag1 = line1.getLineFragmentAt(j);
                ColoredText.LineFragment frag2 = line2.getLineFragmentAt(j);
                if (!frag1.getText().equals(frag2.getText())) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private IResponseEnumeration getResponse(WebRequest req, String lastModified, CancelableRunner cancelable, int sequence, IFile file, boolean oyster, boolean active, RendererResource rendererResource) {
        try {
            WebResponse wr;
            if (lastModified != null) {
                req.setHeaderField("If-Modified-Since", lastModified);
            }
            if ((wr = GikoServer.getWebConversation().getResponse(req)).getResponseCode() == 200) {
                RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(0, wr.getInputStream());
                InputStreamReader r = new InputStreamReader((InputStream)cin, "Windows-31J");
                int contentLength = 0;
                String enc = wr.getHeaderField("Content-Encoding");
                String len = wr.getHeaderField("Content-Length");
                if (enc != null && enc.equals("gzip") && oyster) {
                    contentLength = this.readContentLength(r);
                } else if (len != null) {
                    contentLength = Integer.parseInt(wr.getHeaderField("Content-Length"));
                }
                return new ThreadDownloader("?", cancelable, r, cin, false, sequence, wr.getHeaderField("Last-Modified"), new ArrayList(), 0, contentLength, file, active, rendererResource);
            }
            if (wr.getResponseCode() == 304) {
                return new NullResponseEnumeration("?", sequence);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        return null;
    }

    private int readContentLength(InputStreamReader r) throws IOException {
        if (r.read() != 43 || r.read() != 79 || r.read() != 75 || r.read() != 32) {
            throw new IOException();
        }
        int ch = r.read();
        StringBuffer buf = new StringBuffer();
        while (ch != 47) {
            buf.append((char)ch);
            ch = r.read();
        }
        ch = r.read();
        while (ch != 47) {
            ch = r.read();
        }
        r.read();
        return Integer.parseInt(buf.toString());
    }

    public int getCachedCount() {
        block9: {
            try {
                IFile file = this.logFolder.getFile(this.getID());
                if (!file.exists()) break block9;
                LogFile log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())));
                try {
                    if (log != null) {
                        int n = log.responseCount;
                        Object var3_4 = null;
                        if (log != null) {
                            log.close();
                        }
                        return n;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (log != null) {
                        log.close();
                    }
                    throw throwable;
                }
                Object var3_6 = null;
                if (log != null) {
                    log.close();
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
        return 0;
    }

    public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String selection) {
        return HoverLineFragment.fillToolTip(parent, sourceText, maxWidth, selection);
    }

    private static String toASCIIDigits(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if ('\uff10' <= ch && ch <= '\uff19') {
                ch = (char)(48 + (ch - 65296));
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    static /* synthetic */ IFolder access$2(ThreadContentProvider threadContentProvider) {
        return threadContentProvider.logFolder;
    }

    static /* synthetic */ String access$3(ThreadContentProvider threadContentProvider) {
        return threadContentProvider.id;
    }

    private class ThreadDownloader
    implements IResponseEnumeration,
    IRunnableWithProgress {
        private String title;
        private Reader r;
        private RangeAnalyzeInputStream cin;
        private boolean partial;
        private int sequence;
        private String lastModified;
        private List log;
        private IFile logFile;
        private int position;
        private int contentRange;
        private int contentLength;
        private boolean closed;
        private boolean active;
        private RendererResource rendererResource;

        public ThreadDownloader(String title, CancelableRunner cancelable, Reader r, RangeAnalyzeInputStream cin, boolean partial, int sequence, String lastModified, List log, int position, int contentLength, IFile logFile, boolean active, RendererResource rendererResource) {
            this.title = title;
            this.r = r;
            this.cin = cin;
            this.partial = partial;
            this.sequence = sequence;
            this.lastModified = lastModified;
            this.log = log;
            this.position = position;
            this.contentLength = contentLength;
            this.logFile = logFile;
            this.active = active;
            this.rendererResource = rendererResource;
            this.contentRange = cin.getRange();
            cancelable.run(null, this);
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    boolean get = false;
                    while (true) {
                        ArrayList lines = new ArrayList();
                        String title = LogFile.parseResponse(this.r, lines, this.log.size() + 1, this.rendererResource);
                        if (lines.size() == 0) break;
                        get = true;
                        this.log.add(lines);
                        if (this.log.size() == 1) {
                            this.title = title;
                        }
                        ThreadDownloader threadDownloader = this;
                        synchronized (threadDownloader) {
                            this.notifyAll();
                        }
                        Thread.yield();
                    }
                    if (get) {
                        this.setLog(this.cin.getRange());
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ThreadDownloader threadDownloader = this;
                synchronized (threadDownloader) {
                    this.closed = true;
                    this.notifyAll();
                    try {
                        this.r.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var6_8 = null;
            ThreadDownloader threadDownloader = this;
            synchronized (threadDownloader) {
                this.closed = true;
                this.notifyAll();
                try {
                    this.r.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void setLog(int pos) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            LogFile.writeLogFile(dout, this.sequence, this.title, this.lastModified, this.active, pos, this.log, this.rendererResource);
            dout.close();
            byte[] bytes = bout.toByteArray();
            GikoServer.asyncExec(ThreadContentProvider.this.workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(this, bytes){
                private final /* synthetic */ ThreadDownloader this$1;
                private final /* synthetic */ byte[] val$bytes;
                {
                    this.this$1 = threadDownloader;
                    this.val$bytes = byArray;
                }

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IFile cache = ThreadContentProvider.access$2(ThreadDownloader.access$0(this.this$1)).getFile(ThreadContentProvider.access$3(ThreadDownloader.access$0(this.this$1)));
                        MonalipsePlugin.ensureSynchronized(cache);
                        if (cache.exists()) {
                            cache.setContents((InputStream)new ByteArrayInputStream(this.val$bytes), false, false, monitor);
                        } else {
                            cache.create((InputStream)new ByteArrayInputStream(this.val$bytes), false, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return !this.closed && this.position < this.log.size();
        }

        public boolean hasNextResponse() {
            return !this.closed || this.position < this.log.size();
        }

        public boolean getNextResponse(List lineReceiver) throws InterruptedException {
            ThreadDownloader threadDownloader = this;
            synchronized (threadDownloader) {
                while (!this.closed && this.position == this.log.size()) {
                    this.wait();
                }
            }
            if (this.position < this.log.size()) {
                lineReceiver.addAll((Collection)this.log.get(this.position++));
                return true;
            }
            return false;
        }

        public int getProgressHint() {
            if (this.contentLength == 0) {
                return 100;
            }
            return Math.max((this.cin.getRange() - this.contentRange) * 100 / this.contentLength, 100);
        }

        public void close() {
        }

        public boolean isWritable() {
            return this.active;
        }

        static /* synthetic */ ThreadContentProvider access$0(ThreadDownloader threadDownloader) {
            return threadDownloader.ThreadContentProvider.this;
        }
    }

    private class ArrayThreadReader
    implements IResponseEnumeration {
        private String title;
        private boolean partial;
        private int sequence;
        private List log;
        private int position;
        private boolean active;

        public ArrayThreadReader(String title, boolean partial, int sequence, List log, int position, boolean active) {
            this.title = title;
            this.partial = partial;
            this.sequence = sequence;
            this.log = log;
            this.position = position;
            this.active = active;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return this.position < this.log.size();
        }

        public boolean hasNextResponse() {
            return this.position < this.log.size();
        }

        public boolean getNextResponse(List lineReceiver) throws InterruptedException {
            if (this.position < this.log.size()) {
                lineReceiver.addAll((Collection)this.log.get(this.position++));
                return true;
            }
            return false;
        }

        public int getProgressHint() {
            return Math.max(this.position * 100 / this.log.size(), 100);
        }

        public void close() {
        }

        public boolean isWritable() {
            return this.active;
        }
    }

    private static class RangeAnalyzeInputStream
    extends InputStream {
        private int range;
        private int lf;
        private int count;
        private InputStream in;

        public RangeAnalyzeInputStream(int range, InputStream in) {
            this.range = range;
            this.in = in;
            this.lf = range;
            this.count = range;
        }

        public int getRange() {
            return this.range;
        }

        public int read() throws IOException {
            int r = this.in.read();
            if (r == 10) {
                this.range = this.lf;
                this.lf = this.count + 1;
            }
            ++this.count;
            return r;
        }

        public int read(byte[] b) throws IOException {
            int r = this.in.read(b);
            int i = 0;
            while (i < r) {
                if (b[i] == 10) {
                    this.range = this.lf;
                    this.lf = this.count + i + 1;
                }
                ++i;
            }
            this.count += r;
            return r;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.in.read(b, off, len);
            int end = off + len;
            int i = off;
            while (i < end) {
                if (b[i] == 10) {
                    this.range = this.lf;
                    this.lf = this.count + i - off + 1;
                }
                ++i;
            }
            this.count += r;
            return r;
        }
    }

    private static class ThreadLogReader
    implements IResponseEnumeration {
        private String title;
        private LogFile log;
        private int sequence;
        private boolean partial;
        private boolean active;
        private RendererResource rendererResource;

        public ThreadLogReader(String title, LogFile log, boolean partial, int sequence, boolean active, RendererResource rendererResource) {
            this.title = title;
            this.log = log;
            this.sequence = sequence;
            this.partial = partial;
            this.active = active;
            this.rendererResource = rendererResource;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return this.hasNextResponse();
        }

        public boolean hasNextResponse() {
            return this.log.available();
        }

        public boolean getNextResponse(List lineReceiver) {
            try {
                this.log.readResponse(lineReceiver, this.rendererResource);
                return true;
            }
            catch (IOException iOException) {
                this.log.close();
                return false;
            }
        }

        public int getProgressHint() {
            return 100;
        }

        public void close() {
            this.log.close();
        }

        public boolean isWritable() {
            return this.active;
        }
    }

    private static class NullResponseEnumeration
    implements IResponseEnumeration {
        private String title;
        private int sequence;

        public NullResponseEnumeration(String title, int sequence) {
            this.title = title;
            this.sequence = sequence;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return true;
        }

        public boolean isReady() {
            return false;
        }

        public boolean hasNextResponse() {
            return false;
        }

        public boolean getNextResponse(List lineReceiver) {
            return false;
        }

        public int getProgressHint() {
            return 100;
        }

        public void close() {
        }

        public boolean isWritable() {
            return false;
        }
    }

    private static class LogFile {
        private static final int LOG_FILE_VERSION = 11;
        private static final int RESPONSE_BODY_INDENT = 32;
        private static final int STYLE_UNDERLINE = 1;
        private static final int STYLE_LINK = 2;
        private DataInputStream din;
        public int version;
        public int sequence;
        public String title;
        public String lastModifierd;
        public boolean isActive;
        public int httpRangeStart;
        public int responseCount;
        private int responseRead;

        public static LogFile of(DataInputStream din) throws IOException {
            LogFile res;
            block4: {
                res = null;
                try {
                    int version = din.readInt();
                    if (version == 11) {
                        res = new LogFile(din);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    if (res == null) {
                        din.close();
                    }
                    throw throwable;
                }
                Object var3_5 = null;
                if (res != null) break block4;
                din.close();
            }
            return res;
        }

        LogFile(DataInputStream din) throws IOException {
            this.din = din;
            this.version = 11;
            this.sequence = din.readInt();
            this.title = din.readUTF();
            this.lastModifierd = din.readUTF();
            this.isActive = din.readInt() != 0;
            this.httpRangeStart = din.readInt();
            this.responseCount = din.readInt();
        }

        public void close() {
            try {
                if (this.din != null) {
                    this.din.close();
                }
                this.din = null;
            }
            catch (IOException iOException) {}
        }

        public boolean available() {
            return this.responseRead < this.responseCount;
        }

        public void skipResponse() throws IOException {
            this.din.skipBytes(this.din.readShort());
            int lineCount = this.din.readInt();
            int i = 0;
            while (i < lineCount) {
                int fragmentCount = this.din.readInt();
                int j = 0;
                while (j < fragmentCount) {
                    this.din.skipBytes(12);
                    this.din.skipBytes(this.din.readShort() + 8);
                    ++j;
                }
                ++i;
            }
        }

        public void readResponse(List lineReceiver, RendererResource rendererResource) throws IOException {
            ++this.responseRead;
            String text = this.din.readUTF();
            int lineCount = this.din.readInt();
            int i = 0;
            while (i < lineCount) {
                ColoredText.Line line = i == 0 ? new ResponseHeaderLine(0, this.responseRead) : new ColoredText.Line(32);
                int fragmentCount = this.din.readInt();
                int j = 0;
                while (j < fragmentCount) {
                    int offset = this.din.readInt();
                    int length = this.din.readInt();
                    int style = this.din.readInt();
                    boolean isLink = (style & 2) != 0;
                    String link = "";
                    if (isLink) {
                        link = this.din.readUTF();
                    } else {
                        this.din.skipBytes(this.din.readShort());
                    }
                    Color color = rendererResource.getColor(this.din.readInt());
                    Font font = rendererResource.getFont(this.din.readInt());
                    if (isLink) {
                        if (color == rendererResource.blue) {
                            line.addLineFragment(new LinkedLineFragment(text, offset, length, color, font, (style & 1) != 0, false, rendererResource, link));
                        } else {
                            line.addLineFragment(new HoverLineFragment(text, offset, length, color, font, (style & 1) != 0, false, rendererResource, link));
                        }
                    } else {
                        line.addLineFragment(new MarkedLineFragment(text, offset, length, color, font, (style & 1) != 0, false, rendererResource));
                    }
                    ++j;
                }
                lineReceiver.add(line);
                ++i;
            }
        }

        private static int skipWhitespace(Reader r) throws IOException {
            int ch = r.read();
            while (ch != -1 && Character.isWhitespace((char)ch)) {
                ch = r.read();
            }
            return ch;
        }

        private static void convertMatches(String text, ColoredText.Line line, RendererResource rendererResource, Color color, Font font, PatternAction[] patterns, boolean newMark) {
            int done = 0;
            Matcher[] matchers = new Matcher[patterns.length];
            int i = 0;
            while (i < matchers.length) {
                matchers[i] = patterns[i].matcher(text);
                ++i;
            }
            boolean[] matchs = new boolean[matchers.length];
            int i2 = 0;
            while (i2 < matchs.length) {
                matchs[i2] = patterns[i2].next(matchers[i2]);
                ++i2;
            }
            while (true) {
                int start = Integer.MAX_VALUE;
                int first = -1;
                int i3 = 0;
                while (i3 < matchs.length) {
                    if (matchs[i3] && matchers[i3].start() < start) {
                        start = matchers[i3].start();
                        first = i3;
                    }
                    ++i3;
                }
                if (first == -1) break;
                int end = matchers[first].end();
                if (done <= start) {
                    String link = patterns[first].getLink(matchers[first]);
                    line.addLineFragment(new MarkedLineFragment(text, done, start - done, color, font, false, newMark, rendererResource));
                    if (patterns[first].isLink()) {
                        line.addLineFragment(new LinkedLineFragment(text, start, end - start, rendererResource.blue, font, true, newMark, rendererResource, link));
                    } else {
                        line.addLineFragment(new HoverLineFragment(text, start, end - start, color, font, true, newMark, rendererResource, link));
                    }
                    done = end;
                }
                matchs[first] = patterns[first].next(matchers[first]);
                if (!matchs[first] || matchers[first].start() != start) continue;
                matchs[first] = false;
            }
            line.addLineFragment(new MarkedLineFragment(text, done, text.length() - done, color, font, false, newMark, rendererResource));
        }

        private static ColoredText.Line readToken(Reader r, List lineReceiver, ColoredText.Line line, RendererResource rendererResource, Color color, Font font, PatternAction[] patterns, boolean newMark) throws IOException {
            StringBuffer buf = new StringBuffer(128);
            int ch = r.read();
            while (ch == 32) {
                ch = r.read();
            }
            block3: while (ch != -1) {
                if (ch == 60) {
                    if (buf.length() > 0) {
                        String text = buf.toString();
                        if (patterns == null) {
                            line.addLineFragment(new MarkedLineFragment(text, 0, text.length(), color, font, false, newMark, rendererResource));
                        } else {
                            LogFile.convertMatches(text, line, rendererResource, color, font, patterns, newMark);
                        }
                    }
                    buf = new StringBuffer(128);
                    ch = r.read();
                    if (ch == 62) {
                        return line;
                    }
                    StringBuffer tagBuf = new StringBuffer(32);
                    while (ch != 62) {
                        tagBuf.append((char)ch);
                        ch = r.read();
                        if (ch != -1) continue;
                        return null;
                    }
                    ch = r.read();
                    String tag = tagBuf.toString().toLowerCase();
                    if (tag.equals("b")) {
                        font = rendererResource.boldFont;
                        continue;
                    }
                    if (tag.equals("/b")) {
                        font = rendererResource.font;
                        continue;
                    }
                    if (tag.equals("br")) {
                        lineReceiver.add(line);
                        line = new ColoredText.Line(32);
                        while (true) {
                            if (ch != 32) continue block3;
                            ch = r.read();
                        }
                    }
                    if (tag.startsWith("a ")) continue;
                    if (tag.indexOf("red") != -1) {
                        color = rendererResource.red;
                        continue;
                    }
                    if (tag.indexOf("forestgreen") == -1) continue;
                    color = rendererResource.forestgreen;
                    continue;
                }
                if (ch == 38) {
                    ch = r.read();
                    if (ch == 35) {
                        block34: {
                            ch = r.read();
                            boolean x16 = false;
                            if (ch == 120) {
                                x16 = true;
                                ch = r.read();
                            }
                            StringBuffer b = new StringBuffer();
                            while (Character.isDigit((char)ch) && b.length() < 5) {
                                b.append((char)ch);
                                ch = r.read();
                            }
                            try {
                                buf.append((char)Integer.parseInt(b.toString(), x16 ? 16 : 10));
                            }
                            catch (NumberFormatException numberFormatException) {
                                buf.append("&#");
                                if (x16) {
                                    buf.append('x');
                                }
                                buf.append(b.toString());
                                if (ch != 59) break block34;
                                buf.append(';');
                            }
                        }
                        if (ch != 59) continue;
                        ch = r.read();
                        continue;
                    }
                    StringBuffer b = new StringBuffer();
                    while (Character.isLetter((char)ch) && b.length() < 6) {
                        b.append((char)ch);
                        ch = r.read();
                    }
                    String ref = b.toString();
                    if (ref.equals("lt")) {
                        buf.append('<');
                    } else if (ref.equals("gt")) {
                        buf.append('>');
                    } else if (ref.equals("amp")) {
                        buf.append('&');
                    } else if (ref.equals("apos")) {
                        buf.append('\'');
                    } else if (ref.equals("quot")) {
                        buf.append('\"');
                    } else if (ref.equals("hearts")) {
                        buf.append('\u2665');
                    } else {
                        buf.append('&').append(String.valueOf(ref) + (ch == 59 ? ";" : ""));
                    }
                    if (ch != 59) continue;
                    ch = r.read();
                    continue;
                }
                buf.append((char)ch);
                ch = r.read();
            }
            return null;
        }

        private static String parseResponse(Reader r, List lineReceiver, int responseNumber, RendererResource rendererResource) throws IOException {
            try {
                ResponseHeaderLine headerLine = new ResponseHeaderLine(0, responseNumber);
                headerLine.addLineFragment(new ColoredText.LineFragment(String.valueOf(responseNumber) + " : ", rendererResource.black, rendererResource.font, false));
                if (LogFile.readToken(r, null, headerLine, rendererResource, rendererResource.forestgreen, rendererResource.boldFont, NAME_PATTERN_SET, false) == null) {
                    return null;
                }
                headerLine.addLineFragment(new ColoredText.LineFragment(" ", rendererResource.black, rendererResource.font, false));
                if (LogFile.readToken(r, null, headerLine, rendererResource, rendererResource.blue, rendererResource.boldFont, MAIL_PATTERN_SET, false) == null) {
                    return null;
                }
                headerLine.addLineFragment(new ColoredText.LineFragment(" : ", rendererResource.black, rendererResource.font, false));
                if (LogFile.readToken(r, null, headerLine, rendererResource, rendererResource.black, rendererResource.font, DATE_PATTERN_SET, true) == null) {
                    return null;
                }
                lineReceiver.add(headerLine);
                ColoredText.Line line = LogFile.readToken(r, lineReceiver, new ColoredText.Line(32), rendererResource, rendererResource.black, rendererResource.font, BODY_PATTERN_SET, false);
                if (line == null) {
                    return null;
                }
                lineReceiver.add(line);
                lineReceiver.add(new ColoredText.Line(32));
                String title = null;
                int ch = r.read();
                if (ch != -1 && ch != 10) {
                    StringBuffer buf = new StringBuffer();
                    while (ch != -1 && ch != 10) {
                        buf.append((char)ch);
                        ch = r.read();
                    }
                    title = buf.toString();
                }
                return title;
            }
            catch (RuntimeException runtimeException) {
                return "";
            }
        }

        private static void writeLogFile(DataOutputStream dout, int sequence, String title, String lastModified, boolean isActive, int httpRangeStart, List logs, RendererResource rendererResource) throws IOException {
            dout.writeInt(11);
            dout.writeInt(sequence);
            dout.writeUTF(title);
            dout.writeUTF(lastModified);
            dout.writeInt(isActive ? 1 : 0);
            dout.writeInt(httpRangeStart);
            dout.writeInt(logs.size());
            int i = 0;
            while (i < logs.size()) {
                List resp = (List)logs.get(i);
                StringBuffer buf = new StringBuffer();
                int j = 0;
                while (j < resp.size()) {
                    ColoredText.Line line = (ColoredText.Line)resp.get(j);
                    buf.append(line.getText());
                    ++j;
                }
                dout.writeUTF(buf.toString());
                int textOffset = 0;
                dout.writeInt(resp.size());
                int j2 = 0;
                while (j2 < resp.size()) {
                    ColoredText.Line line = (ColoredText.Line)resp.get(j2);
                    dout.writeInt(line.getLineFragmentCount());
                    int k = 0;
                    while (k < line.getLineFragmentCount()) {
                        int style;
                        ColoredText.LineFragment frag = line.getLineFragmentAt(k);
                        dout.writeInt(textOffset);
                        dout.writeInt(frag.getTextLength());
                        textOffset += frag.getTextLength();
                        int n = style = frag.getUnderline() ? 1 : 0;
                        if (frag instanceof HoverLineFragment) {
                            dout.writeInt(style | 2);
                            dout.writeUTF(((HoverLineFragment)frag).getReference());
                        } else {
                            dout.writeInt(style);
                            dout.writeUTF("");
                        }
                        dout.writeInt(rendererResource.getKey(frag.getColor()));
                        dout.writeInt(rendererResource.getKey(frag.getFont()));
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
        }
    }

    private static abstract class PatternAction {
        private Pattern pattern;

        public PatternAction(Pattern pattern) {
            this.pattern = pattern;
        }

        public Matcher matcher(String text) {
            return this.pattern.matcher(text);
        }

        public boolean next(Matcher m) {
            return m.find();
        }

        public boolean isLink() {
            return true;
        }

        public abstract String getLink(Matcher var1);
    }

    private static class LinkedLineFragment
    extends HoverLineFragment
    implements IThreadToolTipProvider,
    ColoredText.LinkTarget {
        static /* synthetic */ Class class$0;

        public LinkedLineFragment(String text, int offset, int length, Color color, Font font, boolean underline, boolean newMark, RendererResource rendererResource, String href) {
            super(text, offset, length, color, font, underline, newMark, rendererResource, href);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void linkClicked(ColoredText text) {
            String href = this.getReference();
            if (href.startsWith("#") && href.indexOf(45) != -1) {
                int start = Integer.parseInt(href.substring(1, href.indexOf(45)).trim());
                int i = 0;
                while (i < text.getLineCount()) {
                    ResponseHeaderLine rhl;
                    ColoredText.Line line = text.getLineAt(i);
                    if (line instanceof ResponseHeaderLine && start == (rhl = (ResponseHeaderLine)line).getReponseNumber()) {
                        text.scrollTo(new ColoredText.TextPosition(i, 0), 128);
                        return;
                    }
                    ++i;
                }
                return;
            }
            if (!href.startsWith("http")) return;
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IThreadContentProvider thread = BBSServerManager.getThreadContentProviderOf(new URL(href), window);
                if (thread != null) {
                    IWorkbenchPage page = window.getActivePage();
                    try {
                        IEditorPart part;
                        ThreadEditorInput threadEditorInput = new ThreadEditorInput(thread);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!((part = page.openEditor((IEditorInput)threadEditorInput, clazz.getName())) instanceof ThreadViewerEditor)) return;
                        ((ThreadViewerEditor)part).updateThread();
                        return;
                    }
                    catch (PartInitException ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                Program.launch((String)href);
                return;
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class HoverLineFragment
    extends MarkedLineFragment
    implements IThreadToolTipProvider {
        private String href;

        public HoverLineFragment(String text, int offset, int length, Color color, Font font, boolean underline, boolean newMark, RendererResource rendererResource, String href) {
            super(text, offset, length, color, font, underline, newMark, rendererResource);
            this.href = href;
        }

        public String getReference() {
            return this.href;
        }

        public void prefetchToolTip() {
        }

        public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth) {
            ArrayList<ColoredText.Line> lines = new ArrayList<ColoredText.Line>();
            if (this.href.startsWith("#") && this.href.indexOf(45) != -1) {
                int start = Integer.parseInt(this.href.substring(1, this.href.indexOf(45)).trim());
                int end = Integer.parseInt(this.href.substring(this.href.indexOf(45) + 1, this.href.length()).trim());
                boolean copy = false;
                int i = 0;
                while (i < sourceText.getLineCount()) {
                    ColoredText.Line line = sourceText.getLineAt(i);
                    if (line instanceof ResponseHeaderLine) {
                        ResponseHeaderLine rhl = (ResponseHeaderLine)line;
                        if (start <= rhl.getReponseNumber()) {
                            copy = true;
                        }
                        if (end < rhl.getReponseNumber()) {
                            copy = false;
                        }
                    }
                    if (copy) {
                        lines.add(line);
                    }
                    ++i;
                }
            } else if (this.href.startsWith("id:") || this.href.startsWith("trip:")) {
                boolean copy = false;
                int i = 0;
                while (i < sourceText.getLineCount()) {
                    ColoredText.Line line = sourceText.getLineAt(i);
                    if (line instanceof ResponseHeaderLine) {
                        copy = false;
                        int j = 0;
                        while (j < line.getLineFragmentCount()) {
                            ColoredText.LineFragment f = line.getLineFragmentAt(j);
                            if (f instanceof HoverLineFragment && ((HoverLineFragment)f).getReference().equals(this.href)) {
                                copy = true;
                            }
                            ++j;
                        }
                    }
                    if (copy) {
                        lines.add(line);
                    }
                    ++i;
                }
            }
            int i = lines.size() - 1;
            while (i >= 0) {
                ColoredText.Line line = (ColoredText.Line)lines.get(i);
                if (line.getLineFragmentCount() != 0) break;
                lines.remove(i);
                --i;
            }
            return HoverLineFragment.createToolTip(parent, sourceText, maxWidth, lines, this.href);
        }

        public static Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String selection) {
            ColoredText.Line line;
            int i;
            ArrayList<ColoredText.Line> lines = new ArrayList<ColoredText.Line>();
            try {
                int num = Integer.parseInt(selection.trim());
                boolean copy = false;
                i = 0;
                while (i < sourceText.getLineCount()) {
                    line = sourceText.getLineAt(i);
                    if (line instanceof ResponseHeaderLine) {
                        ResponseHeaderLine rhl = (ResponseHeaderLine)line;
                        boolean bl = copy = num == rhl.getReponseNumber();
                    }
                    if (copy) {
                        lines.add(line);
                    }
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (lines.size() == 0) {
                boolean copy = false;
                int lastHeader = 0;
                i = 0;
                while (i < sourceText.getLineCount()) {
                    line = sourceText.getLineAt(i);
                    if (line instanceof ResponseHeaderLine) {
                        if (copy) {
                            int j = lastHeader;
                            while (j < i) {
                                lines.add(sourceText.getLineAt(j));
                                ++j;
                            }
                        }
                        copy = false;
                        lastHeader = i;
                    }
                    if (line.toString().indexOf(selection) != -1) {
                        copy = true;
                    }
                    ++i;
                }
            }
            return HoverLineFragment.createToolTip(parent, sourceText, maxWidth, lines, "(not found)");
        }

        private static Point createToolTip(Composite parent, ColoredText sourceText, int maxWidth, List lines, String errorMsg) {
            if (lines.size() > 0) {
                ColoredText text = new ColoredText(parent, 512);
                text.setLineSkip(sourceText.getLineSkip());
                text.setBackground(sourceText.getBackground());
                text.setToolTipProvider(sourceText.getToolTipProvider());
                text.setToolTipSource(sourceText);
                text.addLines(lines);
                Point size = text.computeSize(-1, -1, true);
                if (maxWidth < size.x) {
                    size = new Point(maxWidth, text.setWrapWidth(maxWidth));
                }
                text.setSize(size);
                return size;
            }
            Label label = new Label(parent, 0);
            label.setText(errorMsg);
            return label.computeSize(-1, -1);
        }
    }

    private static class MarkedLineFragment
    extends ColoredText.LineFragment
    implements INewResponseLineFragment {
        private Color color;
        private boolean newMark;

        public MarkedLineFragment(String text, int offset, int length, Color color, Font font, boolean underline, boolean newMark, RendererResource rendererResource) {
            super(text, offset, length, newMark ? rendererResource.red : color, font, underline);
            this.color = color;
            this.newMark = newMark;
        }

        public void unmark(RendererResource rendererResource) {
            if (this.newMark) {
                this.setColor(this.color);
            }
        }

        public Color getColor() {
            return this.color;
        }
    }

    private static class ResponseHeaderLine
    extends ColoredText.Line
    implements IResponseHeaderLine {
        private int responseNumber;

        public ResponseHeaderLine(int indent, int responseNumber) {
            super(indent);
            this.responseNumber = responseNumber;
        }

        public int getReponseNumber() {
            return this.responseNumber;
        }
    }
}

