/*
 * Decompiled with CFR 0.152.
 */
package monalipse.editors;

import monalipse.editors.ThreadEditorInputFactory;
import monalipse.server.IThreadContentProvider;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class ThreadEditorInput
implements IEditorInput,
IPersistableElement,
IAdaptable {
    private String baseURL;
    private String urlHint;
    private IFolder folder;
    private String id;
    private String title;
    private String tooltip;

    public ThreadEditorInput(String baseURL, String urlHint, IFolder folder, String id, String title, String tooltip) {
        this.baseURL = baseURL;
        this.urlHint = urlHint;
        this.folder = folder;
        this.id = id;
        this.title = title;
        this.tooltip = tooltip;
    }

    public ThreadEditorInput(IThreadContentProvider thread) {
        this.baseURL = thread.getBaseURL();
        this.urlHint = thread.getURLHint();
        this.folder = thread.getLogFolder();
        this.id = thread.getID();
        this.title = thread.getName();
        this.tooltip = String.valueOf(thread.getName()) + "\n" + this.urlHint;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadEditorInput) {
            ThreadEditorInput ei = (ThreadEditorInput)obj;
            return ei.folder.equals((Object)this.folder) && ei.id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getURLHint() {
        return this.urlHint;
    }

    public IFolder getLogFolder() {
        return this.folder;
    }

    public String getID() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFactoryId() {
        return ThreadEditorInputFactory.getFactoryId();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(".2chdat");
    }

    public String getName() {
        return this.title;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public void saveState(IMemento memento) {
        ThreadEditorInputFactory.saveState(memento, this);
    }
}

