/*
 * Decompiled with CFR 0.152.
 */
package monalipse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MonalipsePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "monalipse";
    public static final String NATURE_ID = "monalipse.monalipsenature";
    private static MonalipsePlugin plugin;
    private ResourceBundle resourceBundle;

    public MonalipsePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("monalipse.MonalipsePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static MonalipsePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MonalipsePlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String formatResourceString(String key, Object[] args) {
        return MessageFormat.format(MonalipsePlugin.getResourceString(key), args);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static InputStream getUTFInputStream(String str) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(str);
        return new ByteArrayInputStream(bout.toByteArray());
    }

    public static void ensureSynchronized(IFile file) throws CoreException {
        if (!file.isSynchronized(0)) {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

