/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.WebFrame;
import com.meterware.httpunit.WebRequest;
import java.net.URL;
import java.util.StringTokenizer;
import org.w3c.dom.Node;

public abstract class WebRequestSource
extends ParameterHolder {
    private static final String PARAM_DELIM = "&";
    private String _pageFrame;
    private URL _baseURL;
    private String _destination;
    private Node _node;

    public String getID() {
        return NodeUtils.getNodeAttribute(this._node, "id");
    }

    public String getName() {
        return NodeUtils.getNodeAttribute(this._node, "name");
    }

    public String getTarget() {
        if (this.getSpecifiedTarget().length() == 0) {
            return this._pageFrame;
        }
        if (this.getSpecifiedTarget().equalsIgnoreCase("_self")) {
            return this._pageFrame;
        }
        if (this.getSpecifiedTarget().equalsIgnoreCase("_top")) {
            return "_top";
        }
        return WebFrame.getTargetFrameName(this._pageFrame, this.getSpecifiedTarget());
    }

    public Node getDOMSubtree() {
        return this._node.cloneNode(true);
    }

    public abstract WebRequest getRequest();

    public abstract String[] getParameterNames();

    public abstract String[] getParameterValues(String var1);

    String getRelativeURL() {
        String url = this.getDestinationPage();
        int questionMarkIndex = url.indexOf("?");
        if (questionMarkIndex >= 1 && questionMarkIndex < url.length() - 1) {
            return url.substring(0, questionMarkIndex);
        }
        return url;
    }

    private String getDestinationPage() {
        String result = this.trimFragment(this.getDestination());
        if (result.trim().length() == 0) {
            result = this.getBaseURL().getFile();
        }
        return result;
    }

    private String trimFragment(String href) {
        int hashIndex = href.indexOf(35);
        if (hashIndex < 0) {
            return href;
        }
        return href.substring(0, hashIndex);
    }

    WebRequestSource(Node node, URL baseURL, String destination, String pageFrame) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        this._node = node;
        this._baseURL = baseURL;
        this._destination = destination;
        this._pageFrame = pageFrame;
    }

    protected URL getBaseURL() {
        return this._baseURL;
    }

    protected String getDestination() {
        return this._destination;
    }

    protected Node getNode() {
        return this._node;
    }

    protected final void loadDestinationParameters() {
        StringTokenizer st = new StringTokenizer(this.getParametersString(), PARAM_DELIM);
        while (st.hasMoreTokens()) {
            this.stripOneParameter(st.nextToken());
        }
    }

    protected abstract void addPresetParameter(String var1, String var2);

    private String getSpecifiedTarget() {
        return NodeUtils.getNodeAttribute(this._node, "target");
    }

    private String getParametersString() {
        String url = this.trimFragment(this.getDestination());
        int questionMarkIndex = url.indexOf("?");
        if (questionMarkIndex >= 1 && questionMarkIndex < url.length() - 1) {
            return url.substring(questionMarkIndex + 1);
        }
        return "";
    }

    private void stripOneParameter(String param) {
        int index = param.indexOf("=");
        String value = index < 0 ? null : (index == param.length() - 1 ? "" : HttpUnitUtils.decode(param.substring(index + 1)).trim());
        String name = index < 0 ? param.trim() : HttpUnitUtils.decode(param.substring(0, index)).trim();
        this.addPresetParameter(name, value);
    }
}

