/*!
  \file  mones.cpp
  \brief Code:MonesC

  Copyright (c) 2004 Yamami
  All rights reserved.
  License=MIT/X Licnese

  \author  Yamami
  \version $Revision: 1.3 $
  \date   create:2004/08/08 update:$Date: 2004/10/31 14:29:43 $
*/


//ŁAMones̃O[oIuWFNgCX^X
#define MONES_GLOBAL_VALUE_DEFINED
#include "MonesGlobal.h"

#include <monapi.h>
#include "AbstractMonic.h"
#include "MoEther.h"
#include "MonesConfig.h"
#include "MonesLoader.h"


using namespace MonAPI;


/*!
    \brief MonaMain
        Code:MonesC

    \param List<char*>* pekoe

    \author  Yamami
    \date    create:2004/08/08 update:2004/10/31
*/
int MonaMain(List<char*>* pekoe)
{
    int ret;
    //syscall_get_io  
    //̃vZX쒆́AIOx3܂ŋ
    syscall_get_io();
    
    // NIC̃CX^X
    // MonesLoaderNXoRŃCX^XB
    AbstractMonic* insAbstractNic;
    
    MonesLoader* insNicLoader = new MonesLoader();
    insNicLoader->setup();
    insAbstractNic = insNicLoader->getNicInstance();
    //NIC̃[hɎsꍇ́AMonesI
    if(insAbstractNic == 0){
        printf("NIC Error Mones Quit \n");
        return 0;
    }
    
    //Ne2000MoNic* insAbstractNic = new Ne2000MoNic();
    
    
    //EtherNX̃CX^X
    g_MoEther = new MoEther();
    g_MoEther->etherInit(insAbstractNic);

    //ARPNX̃CX^X
    g_MoArp = new MoArp();
    g_MoArp->initArp(insAbstractNic);

    //IPNX̃CX^X
    g_MoIp = new MoIp();
    g_MoIp->initIp(insAbstractNic);


    // initilize destination list
    //List<dword>* destList = new HList<dword>();
    MessageInfo info;

    // Server start ok
    dword targetID = Message::lookupMainThread("MONITOR.BIN");
    if (targetID == 0xFFFFFFFF)
    {
        printf("Mones:INIT not found\n");
        exit(1);
    }

    // create message
    Message::create(&info, MSG_SERVER_START_OK, 0, 0, 0, NULL);

    // send
    if (Message::send(targetID, &info)) {
        printf("Mones:INIT error\n");
    }

    //lbg[NIRQ}XNEnable
    insAbstractNic->enableNetWork();

    //IRQV[oƂēo^ (IRQ́ANIChCoNX蓾)
    syscall_set_irq_receiver(insAbstractNic->getNicIRQ());


//Yamami fobO
//FileOutputStream fos("MONES.LOG", true);
//printf("open=%x\n", fos.open());

//char logStr[1024];    //Oo͕


    /* Message loop */
    //ŃbZ[W[v
    for (;;)
    {
        /* receive */
        if (!Message::receive(&info))
        {
            
            switch(info.header)
            {
            case MSG_INTERRUPTED:
                
                //printf("MSG_INTERRUPTED\n");
                
                dword    i;
                
                //pPbgM
                insAbstractNic->frame_input();
                
                //EtherNXɓo^
                i = g_MoEther->setEtherFrame(insAbstractNic->frame_buf ,insAbstractNic->frame_len);
                //C[Tlbgt[M 
                i = g_MoEther->receiveEther();
                
                break;

            //Yamami!! pPbgMA
            //case MSG_NET_PACKET_SEND:
                //pPbgM
                //eXg MACAhX֏o͏
                // insAbstractNic->frame_output( (byte *)ne_test_pattern, ether_mac_addr, ne_sizeof_test_pattern, 0x0806 );
                //zXgAhX֏o͏
                // insAbstractNic->frame_output( (byte *)ne_test_pattern, dest_ether_mac_addr, ne_sizeof_test_pattern, 0x0806 );

                //break;


            default:
                /* igonore this message */
                break;
            }

        }
    }
    return 0;
}

