/*!
    \file   MonesLoader.cpp
    \brief  Mones NIChCoCX^X [_[

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.1 $
    \date   create:2004/10/31 update:$Date: 2004/10/31 14:29:43 $
*/

/*! \class MonesLoader
 *  \brief Mones NIChCoCX^X [_[
 */


#include <pci/Pci.h>

#include "MonesLoader.h"
#include "MonesConfig.h"
#include "MonesGlobal.h"
#include "AbstractMonic.h"
#include "Ne2000MoNic.h"

/*!
    \brief initialize
         MonesLoader RXgN^
    \author Yamami
    \date   create:2004/10/31 update:$Date: 2004/10/31 14:29:43 $
*/
MonesLoader::MonesLoader()
{

}


/*!
    \brief initialize
         MonesLoader fXNgN^
    \author Yamami
    \date   create:2004/10/31 update:$Date: 2004/10/31 14:29:43 $
*/
MonesLoader::~MonesLoader() 
{

}


/*!
    \brief setup
         MonesLoader setup
    \author Yamami
    \date   create:2004/10/31 update:$Date: 2004/10/31 14:29:43 $
*/
void MonesLoader::setup() 
{
    //ȂB

}


/*!
    \brief getNicInstance
         NIChCõCX^X𓾂B
    \author Yamami
    \date   create:2004/10/31 update:$Date: 2004/10/31 14:29:43 $
*/
AbstractMonic* MonesLoader::getNicInstance() 
{
    
    //TODO 2004/10/31 
    // PCIfoCXāA QEMU / Ȃ Bochs Ɣf
    // NE2000hCo[hB
    // ̑ł́A[hɎs
    
    int ret;
    PciInf *pciinfo;              //PCICu

    Ne2000MoNic *nicDriver;
    
    //PCICuNX̃CX^X
    Pci* pcilib = new Pci();
    
    //TODO ꎞ̂Ȃ̂ŁA}WbNio[p
    //QEMÚANE2000T
    pciinfo = pcilib->CheckPciExist(0x10EC,0x8029);
    
    if(pciinfo->Exist == 0){
        //
        //NE2000̃[h
        nicDriver = new Ne2000MoNic();
        
        //QEMUݒ
        nicDriver->setNicIRQ(11);
        nicDriver->setNicIOBASE(0xC100);
        
    }
    else{
        //Ȃ
        //NE2000̃[h
        nicDriver = new Ne2000MoNic();
        
        //Bochsݒ
        nicDriver->setNicIRQ(3);
        nicDriver->setNicIOBASE(0x240);
    
    }
    
    
    //NIC
    ret = nicDriver->init();
    
    //if(ret != 0){
    //    //ɎsꍇANULLhCoԂB
    //    nicDriver = 0;
    //    
    //}
    
    
    return nicDriver;
}

