/*!
    \file   MoArp.cpp
    \brief  ARPvgRNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.3 $
    \date   create:2004/08/28 update:$Date: 2004/10/31 14:29:43 $
*/

/*! \class MoArp
 *  \brief ARPvgRNX
 */



#include "MoArp.h"
#include "MonesConfig.h"
#include "MonesGlobal.h"

/*!
    \brief initialize
         MoArp RXgN^
    \author Yamami
    \date   create:2004/08/28 update:
*/
MoArp::MoArp()
{
    //ARPLbV
    
    ArpCache = new HashMap<char*>(ARP_CACHE_NUM);
}

/*!
    \brief initialize
         MoArp initArp
    \author Yamami
    \param  AbstractMonic *pminsNic [in] NICNXւ̃|C^
    \date   create:2004/08/28 update:
*/
void MoArp::initArp(AbstractMonic *pminsNic ) 
{
    //NICNXێ
    insAbstractNic = pminsNic;
    return;
}


/*!
    \brief initialize
         MoArp fXNgN^
    \author Yamami
    \date   create:2004/08/28 update:
*/
MoArp::~MoArp() 
{

}


/*!
    \brief receiveArp
         ARPvgRM 
    \param  ARP_HEADER *arpHead [in] ARPwb_ւ̃|C^
    \return int  
        
    \author Yamami
    \date   create:2004/08/28 update:2004/08/29
*/
int MoArp::receiveArp(ARP_HEADER *arpHead)
{
    
    int rest=0;
    
    // IP̊mF
    // IP̗vŖ΁AȂB
    if(arpHead->dstIp!=MoPacUtl::swapLong(G_MonesCon.getGl_myIpAdr() )){
        return 0;
    }

    // Iy[VR[h̊mF
    switch(MoPacUtl::swapShort(arpHead->opeCode))
    {
        //ARPv
        case OPE_CODE_ARP_REQ:
            transArp(arpHead->srcIp,arpHead->srcMac, OPE_CODE_ARP_REP);
            
            //LbVɓo^
            addArpCache(arpHead->srcIp,(char*)arpHead->srcMac); 
            break;
        //ARP
        case OPE_CODE_ARP_REP:
            //
            //rest=receiveReply(arpHead->srcIp,arpHead->srcMac);
            break;
        
        //RARPv
        case OPE_CODE_RARP_REQ:
        //RARP
        case OPE_CODE_RARP_REP:
            break;
    }

    return rest;

}



static char broadcastMac[]={0xff,0xff,0xff,0xff,0xff,0xff};

/*!
    \brief transArp
         ARP 
    \param  dword dstip [in] MIPAhX
    \param  byte *dstmac [in] MMACAhX
    \param  word opecode [in] Iy[VR[h
    \return void  
        
    \author Yamami
    \date   create:2004/08/28 update:
*/
void MoArp::transArp(dword dstip, byte *dstmac, word opecode)
{
    ARP_HEADER head;

    //p ARPwb_t[쐬
    head.hardType=MoPacUtl::swapShort(HARD_TYPE_ETHER);
    head.protType=MoPacUtl::swapShort(PROT_TYPE_IP);
    head.hardAddrLen=6;
    head.protAddrLen=4;
    head.opeCode=MoPacUtl::swapShort(opecode);
    memcpy(head.srcMac,insAbstractNic->ether_mac_addr,6);
    head.srcIp=MoPacUtl::swapLong(G_MonesCon.getGl_myIpAdr() );
    if(memcmp(dstmac,broadcastMac,6)==0){
    head.srcIp=MoPacUtl::swapLong(G_MonesCon.getGl_myIpAdr() );
    }else{
        memcpy(head.dstMac,dstmac,6);
    }
    head.dstIp=dstip;  //͎󂯎܂ܕԋp̂ŁAGfBAϊ͕sv

    //M ł́AڃhCoR[
    insAbstractNic->frame_output((byte *)&head , dstmac , sizeof(head) , ETHER_PROTO_ARP);

}


/*!
    \brief addArpCache
         ARPLbVo^
    \param  dword ip [in] o^IPAhX
    \param  char *mac [in] o^MACAhX
    \return void  
        
    \author Yamami
    \date   create:2004/09/19 update:
*/
void MoArp::addArpCache(dword ip, char *mac)
{

    char IpKey[10];    //IPAhXL[

    //IPAhXAMAP̃L[(String)
    sprintf(IpKey , "%08x",ip);
    ArpCache->put(IpKey , mac);

}


/*!
    \brief searchCache
         ARPLbV
    \param  dword ip [in] o^IPAhX
    \return char *mac [in] MACAhX ȂꍇNULL
        
    \author Yamami
    \date   create:2004/09/19 update:
*/
char* MoArp::searchCache(dword ip)
{
    char IpKey[10];    //IPAhXL[
    char *RetMacValue;
    
    //HashMap猟
    //IPAhXAMAP̃L[(String)
    sprintf(IpKey , "%08x",ip);
    RetMacValue = ArpCache->get(IpKey);

    return RetMacValue;
}




/*!
    \brief getMac
         ARP IPAhX
    \param  dword ip [in] IPAhX
    \param  byte *mac [OUT] MACAhXւ̃|C^
    \return void  
        
    \author Yamami
    \date   create:2004/09/20 update:
*/
int MoArp::getMac(dword ip,char *mac)
{
    enum{
        RETRY_COUNT=3,          // gCM
        REQUEST_TIMEOUT=2000,   // NGXg^CAEg~b
    };

    char *retmac;

    //int rest;
    //REPLY_WAIT *wait;
    //int i;
    //REPLY_WAIT *p;


    // LbV
    if((retmac=searchCache(ip))!=NULL)
    {
        //LbV猩΁AԂB
        memcpy(mac,retmac,6);
        return 0;
    }

/*

    // M
    if((wait=kmalloc(sizeof(REPLY_WAIT)))==NULL)return -ENOMEM;
    wait->ip=ip;
    wait->repFlg=0;
    wait->next=replyWait;
    replyWait=wait;

    // NGXgARP𑗐M
    for(i=0;;)
    {
        transArp(num,ip,broadcastMac,OPE_CODE_ARP_REQ);
        wait->wait.flag=0;
        wait_intr(&wait->wait,REQUEST_TIMEOUT,TASK_SIGNAL_WAIT);
        if(wait->repFlg)
        {
            addCache(ip,wait->mac);
            memcpy(mac,wait->mac,6);
            rest=0;
            break;
        }
        if(++i>=RETRY_COUNT)
        {
            rest=-ENETUNREACH;
            break;
        }
    }

    // M㏈
    if(replyWait==wait)replyWait=wait->next;
    else
    {
        for(p=replyWait;p->next!=wait;p=p->next);
        p->next=wait->next;
    }
    kfree(wait);

    return rest;

*/

}

