
/*!
    \file   Pci.cpp
    \brief  PCICu PCINX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.1 $
    \date   create:2004/10/15 update:$Date: 2004/10/18 09:09:06 $
*/

/*! \class Pci
 *  \brief PCICu PCINX
 */


#include <monapi.h>
#include <monapi/messages.h>
#include <monapi/CString.h>
#include <pci/Pci.h>

//PCIINFOt@C
#define PCIINFO_FILE "libPci.a"

using namespace MonAPI;




/*!
    \brief initialize
         Pci RXgN^
    \author Yamami
    \date   create:2004/10/15 update:$Date: 2004/10/18 09:09:06 $
*/
Pci::Pci()
{
    //I/O擾
    syscall_get_io();

}


/*!
    \brief initialize
         Pci fXNgN^
    \author Yamami
    \date   create:2004/10/15 update:$Date: 2004/10/18 09:09:06 $
*/
Pci::~Pci() 
{
    //ŁAI/OEEE

}




/*!
    \brief CheckPciExist
         PcifoCX݊mFBw肵Vendor/DevicePCIfoCX݂̑mFB
    \author Yamami
    \param  word Vendor [in] x_[ID
    \param  word Device [in] foCXID
    \return PciInf\̂ւ̃|C^
    \date   create:2004/10/15 update:$Date: 2004/10/18 09:09:06 $
*/
PciInf* Pci::CheckPciExist(word ChkVendor , word ChkDevice ) {
    
    byte DeviceNo;
    dword Vendor_Dev;

    word Vendor;
    word Device;

    dword BaseAd;
    dword  IrqLine;
    
    PciInf RetPciInf; //ԋpp PciInf\

    //ԋpl foCX݂͑ȂB
    RetPciInf.Exist = 1;

    //Yamami!!! 2004/10/18 PCIt@ĆAohł͖AƗ
    //CString bundlePath = MonAPI::System::getBundlePath();
    //pciinfot@CI[v
    //monapi_cmemoryinfo* pciinfData = monapi_call_file_decompress_bz2_file(bundlePath + "/" + PCIINFO_FILE, MONAPI_TRUE);
    //G[
    //if(pciinfData == NULL){
    //    printf("PCI DATA FILE OPEN ERROR !!!\n");
    //}

    //oXԍ0ɂāAfoCXԍ0`31̂ꂼɂāAx_[IDǂݏo
    for(DeviceNo = 0; DeviceNo < 32 ; DeviceNo++ ){
        //ReadConfig pVendor̎擾
        Vendor = ReadConfig(0, DeviceNo, 0, PCI_VENDOR_ID, 2);
        
        if (Vendor != 0xFFFF){
            Device = ReadConfig(0, DeviceNo, 0, PCI_DEVICE_ID, 2);
            if (Device != 0xFFFF && ChkVendor == Vendor && ChkDevice == Device){
                //foCX݂B
                //foCXƃx_[ getPciInfName ɃC^[tF[X킹B
                Vendor_Dev = Vendor + (dword)(Device << 16);
                
                //BaseAhX̎擾
                BaseAd = ReadConfig(0, DeviceNo, 0, PCI_BASE_ADDRESS1, 4);
                
                //IRQC̎擾  google PCI IRQ擾Ō
                IrqLine = ReadConfig(0, DeviceNo, 0, PCI_IRQ_LINE, 1);
                
                //x_[/foCX̂̎擾
                CString VendorName;
                CString DeviceName;

                //CString Dummy = getPciInfName(pciinfData->Data , Vendor_Dev , &VendorName , &DeviceName);
                
                //ԋpl
                RetPciInf.Exist = 0;
                RetPciInf.DeviceNo = DeviceNo;
                RetPciInf.Vendor = Vendor;
                RetPciInf.Device = Device;
                RetPciInf.VendorName = VendorName;
                RetPciInf.DeviceName = DeviceName;
                RetPciInf.BaseAd = BaseAd;
                RetPciInf.IrqLine = IrqLine;
                
                //ꍇ́A[v𔲂
                break;
            }
        }
    }

    //t@C㏈
    //monapi_cmemoryinfo_dispose(pciinfData);
    //monapi_cmemoryinfo_delete(pciinfData);

    //Return
    return &RetPciInf;
    
}


/*!
    \brief ReadConfig
        PCIfoCX擾
    \param  byte bus [in] oXԍ
    \param  byte deviceid [in] foCXԍ
    \param  byte func [in] t@NVԍ
    \param  byte reg [in] WX^AhX
    \param  byte readSize [I] 擾TCY
    \return dword 擾WX^̒l

    \author Yamami
    \date   create:2004/05/15 update:2004/05/15
*/
dword Pci::ReadConfig(byte bus, byte device, byte function, byte reg, byte readSize)
{
   dword result;
   PciPacket packet;

   packet.p.enabled   = 1;
   packet.p.bus       = bus;
   packet.p.device    = device;
   packet.p.function  = function;
   packet.p.reg       = reg & ~3;
   packet.p.reserved1 = 0;
   packet.p.reserved2 = 0;

   /* set request and enable */
   outp32(REG_CONFIG_ADDRESS, packet.command);

   switch (readSize)
   {
   case 1:
       result = inp8(REG_CONFIG_DATA + (reg & 3));
       break;

   case 2:
       result = inp16(REG_CONFIG_DATA + (reg & 3));
       break;

   case 4:
       result = inp32(REG_CONFIG_DATA + (reg & 3));
       break;

   default:
       result = 0xFFFFFFFF;
       break;
   }

   packet.p.enabled = 0;
   outp32(REG_CONFIG_ADDRESS, packet.command);
   return result;
}



/*!
    \brief IsLineSeparator
        Zp[^

    \param  char ch [IN] LN^
    \return bool Zp[^Ȃtrue ȊOȂfalse
    \author Tino
    \date   create:2004/06/111 update:2004/06/11
*/
inline bool Pci::IsLineSeparator(char ch)
{
    return ch == '\r' || ch == '\n' || ch == '\0';
}


/*!
    \brief getPciInfName
        PCI񖼏(x_[AfoCX)擾
        PCIWX^l ɂƂAPCIINF.TXT Yx_[̃x_̂擾BB
    \param  byte* PciInfData [IN] PCIf[^
    \param  dword InValue [IN] PCIWX^l(x_[CD & foCXCD)
    \param  CString& VendorName [OUT] x_[
    \param  CString& DeviceName [OUT] foCX

    \return MonAPI::CString dummy(_~[߂l)

    \author Yamami
    \date   create:2004/05/16 update:2004/06/11
*/
CString Pci::getPciInfName( byte* PciInfData, dword InValue , CString* VendorName , CString* DeviceName){

    word Vendor;
    word Device;

    //x_[ID̎擾
    Vendor = InValue & 0x0000FFFF;
    Device = InValue >> 16;

    char VendorHex[5];    //x_[CDi[p
    char DeviceHex[5];    //x_[CDi[p
    sprintf(VendorHex, "%04X", Vendor);
    sprintf(DeviceHex, "%04X", Device);

    //NULL܂ŌJԂ
    while (*PciInfData != 0){

        //printf("%c",*PciInfData);

        //܂Ax_[̂T
        //CZp[^Ȃ玟̕
        if (IsLineSeparator(*PciInfData)){
            PciInfData++;
        }
        else if (strncmp((const char*)PciInfData, VendorHex, 4) == 0){
            const char* ps = (const char*)(PciInfData + 5), * pe = ps;
            for (; !IsLineSeparator(*pe); pe++);

            //return CString(ps, pe - ps);
            //x_[m
            *VendorName = CString(ps, pe - ps);

            //printf("%s\n",(const char*)VendorName);

            //x_[ȉ̃foCXB
            //1sǂݔ΂
            for (; !IsLineSeparator(*PciInfData); PciInfData++);
            while (*PciInfData != 0){
                if (IsLineSeparator(*PciInfData)){
                    PciInfData++;

                    //CZp[^̎^uȂAfoCX
                    if (strncmp((const char*)PciInfData, "\t", 1) == 0){
                        PciInfData++;
                        if (strncmp((const char*)PciInfData, DeviceHex, 4) == 0){
                            const char* ps = (const char*)(PciInfData + 5), * pe = ps;
                            for (; !IsLineSeparator(*pe); pe++);
                            *DeviceName = CString(ps, pe - ps);

                            //printf("%s\n",(const char*)DeviceName);

                            return "dumy";
                        }
                        else{
                            //̃foCX
                            for (; !IsLineSeparator(*PciInfData); PciInfData++);
                        }
                    }
                    //x_[ύX܂œǂŌȂAsƂB
                    else{
                        *DeviceName = "???";
                        //printf("%s\n",(const char*)DeviceName);
                        return "dumy";
                    }
                }
                else{
                    printf("tobashi\n");

                    //ǂɂYȂs͓ǂݔ΂
                    for (; !IsLineSeparator(*PciInfData); PciInfData++);
                }

            }
        }
        else{
            //ǂɂYȂs͓ǂݔ΂
            for (; !IsLineSeparator(*PciInfData); PciInfData++);
        }
    }

    // s
    *VendorName = "???";
    *DeviceName = "???";
    return "???";
}
