/*!
    \file HogeDriver.h
    \brief HogeDriver for testing filesystem.

    Copyright (c) 2003 HigePon
    WITHOUT ANY WARRANTY

    \author HigePon
    \version $Revision: 1.2 $
    \date create:2003/04/03 update:$Date: 2003/05/18 09:58:56 $
*/

#ifndef _MONA_HOGE_DRIVER_
#define _MONA_HOGE_DRIVER_

#include <fstream>
#include <iostream>
#include "DiskDriver.h"

/*!
    Hoge Driver class
*/
class HogeDriver : public DiskDriver {
  public:
    HogeDriver(const char* file, long size);
    ~HogeDriver();

  public:
    bool read(dword lba, byte* buf);
    bool write(dword lba, byte* buf);

  private:

    std::fstream file_;
};

#endif
