#!/bin/bash
# Make One Linux on Linux File System
# Written by Keicho Kondo 2006.06.09
# Contact: dgel@users.sourceforge.jp
# License GPL

# ChangeLog
# 2007-06-10 Keicho Kondo
# - Fix for Make One Linux 0.7.0.
# 2006-10-10 Keicho Kondo
# - Added noeject option.
# 2006-04-03 Keicho Kondo
# - Modify setup.bat called from install2win.bat for Linux System.

# set kernel and initrd information
KERNEL="$(echo /boot/vmlinuz-mol-* | awk '{print $1}')"
INITRD="$(echo /boot/initrd-mol-*.img | awk '{print $1}')"

# set title
DFTITLE="Make One Linux (Default Mode)"
FSTITLE="Make One Linux (Failsafe Mode)"

# set options
DFOPTIONS="noeject selinux=0"
FSOPTIONS="nocd noswap noaudio noscsi nousb nofirewire noraid nodma nonet nodhcp novideo nowheel noddc noapm noacpi acpi=off vga=normal 3"

# configure boot loader
grubby --copy-default --add-kernel=${KERNEL} --title="${DFTITLE}" --args="${DFOPTIONS}" --initrd="${INITRD}" >/dev/null 2>&1
grubby --copy-default --add-kernel=${KERNEL} --title="${FSTITLE}" --args="${FSOPTIONS}" --initrd="${INITRD}" >/dev/null 2>&1

