#pragma once
#include <mof/Vector2D.hpp>
#include <mof/VertexTypes.hpp>
#include <vector>
#include <memory>
#include "world/Area.hpp"
#include "sqlite_wrapper.hpp"

//{{{ fwd decralation
namespace mof
{
	class Graphics3D;
namespace script
{
	struct GameData;
}
}
//}}}

class World
{
public:
	typedef std::vector<mof::VertexXYZRHWCUV> vertices_t;

	World
	(
		size_t width,
		size_t height,
		::sqlite_wrapper& sqlite	
	);
	~World();

	int regen() const;
	int term() const;
	std::shared_ptr<mof::Graphics3D> world_model() const;
	::Area area(size_t x, size_t y) const;
	mof::tstring make_area_picture_name(size_t x, size_t y) const;
	std::unique_ptr<vertices_t> make_land_region_vertices(size_t x, size_t y) const;
	void put_element(size_t x, size_t y, const mof::tstring& element_name);
	::LandPowerLevel make_land_power
	(
		int forest, int earth,
		float coef_ehves, float coef_bolony, float coef_stra
	) const;

private:
	struct impl;
	std::unique_ptr<impl> pimpl_;
};
