#include "world/MapBuilder.hpp"
#include "resource.hpp"
#include <mof/Graphics3D.hpp>

MapBuilder::MapBuilder(float scale , int width , int height)
: m_scale(scale), m_width(width), m_height(height)
{
}

MapBuilder::~MapBuilder(void)
{
}



std::unique_ptr<mof::Graphics3D> MapBuilder::create(){


	std::vector<VertexTypeMap> vertices;
	
	for(int x = 0 ; x < m_width ; x++){
		for(int y = 0 ; y < m_height ; y++){
			addParts(vertices , x , y);
		}
	}

	return mof::Graphics3D::create_graphics3d
		(
			vertices,
			::getTextureResourceManager(::SYSTEM)->getResource(_T("image/worldtip.png")),
			mof::Material()
		);
}


float MapBuilder::getScale(){
	return m_scale;
}


