#pragma once
#include "world/MapBuilder.hpp"

typedef VertexTypeMap VertexTypeDungeon;

class DungeonBuilder : public MapBuilder
{
	mof::PixelMap m_map;
	int m_blockWidth , m_blockHeight;
protected :
	mof::PixelMap& getMap(){return m_map;}
public:
	DungeonBuilder(mof::PixelMap& map, float scale);
	virtual ~DungeonBuilder(void);
	void setBlockSize(int width , int height);
	std::vector<VertexTypeDungeon> createBlock(int x , int y);
	mof::Color getMapImageColor(int x , int y){return m_map[x][y];}
};

