#include "widget/createMenuView.hpp"
#include <mof/widgets.hpp>
#include "widget/HighlightButtonView.hpp"
#include <mof/FactoryMethod.hpp>
#include <mof/Font.hpp>
#include <mof/utilities.hpp>
#include "configure.hpp"
#include "resource.hpp"
#include <mof/widget/TextCompiler.hpp>

using mof::widget::WidgetView;
using mof::widget::ImageView;

namespace 
{
	std::shared_ptr<mof::widget::AbstractTextCompiler> text_compiler;
}

mof::FactoryMethod<WidgetView> createMenuView(const mof::tstring& text, bool is_disable_item)
{
	//using namespace mof::widget;

	if (text_compiler.get() == NULL) {
		text_compiler = std::make_shared<mof::widget::TextCompiler>
			(
				mof::Font(FONT_NAME_UME, FONT_SIZE_STANDARD),
				[] (const mof::tstring& path) { return ::getTextureResourceManager(::SYSTEM)->getResource(path);}
			);

		text_compiler->setBehaviorOnColor
		(
			mof::widget::AbstractTextCompiler::PAGE_OPEN, 
			mof::makeConstantHandler(mof::Color4f(1, 1, 1, 1)),
			0
		);

		text_compiler->setBehaviorOnColor
		(
			mof::widget::AbstractTextCompiler::PAGE_CLOSE, 
			mof::makeConstantHandler(mof::Color4f(1, 1, 1, 1)),
			0
		);
	}

    return mof::makeFactoryMethod<HighlightButtonView> 
    	(
			[text]() {return text_compiler->compile_to_widget(text).release();},
			is_disable_item
    	);
}



