#include "widget/createFrame.hpp"
#include "widget/ImageTileView.hpp"
#include <mof/widgets.hpp>
#include <mof/Font.hpp>
#include <mof/utilities.hpp>
#include <mof/widget/ImageView.hpp>
#include <mof/FactoryMethod.hpp>
#include <memory>
#include "configure.hpp"
#include "resource.hpp"

using mof::Texture;
using mof::Font;
using mof::makeFactoryMethod;
using mof::Rectangle;
using mof::widget::ImageView;
using std::shared_ptr;
using std::make_shared;
using namespace mof::widget;

std::unique_ptr<Frame> createFrame
(
    const mof::tstring& caption ,
    const mof::tstring& contentImagePath  ,
    const mof::tstring& titleImagePath  ,
    shared_ptr<WidgetView> pContentView
)
{
	mof::FactoryMethod<WidgetView> wv = makeFactoryMethod<NullView>();
	if (titleImagePath != "") wv = makeFactoryMethod<ImageTileView>(make_shared<Texture>(titleImagePath));
	mof::FactoryMethod<WidgetView> content_bg = makeFactoryMethod<NullView>();
	if (contentImagePath != "") content_bg = makeFactoryMethod<ImageTileView>(make_shared<Texture>(contentImagePath));

	std::unique_ptr<Frame> pFrame
    (

        new Frame
        (
            caption , 
            pContentView ,
			content_bg,
            wv,
            makeFactoryMethod<TextCompiler>
			(
				Font( FONT_NAME_UME, FONT_SIZE_LARGE ),
				[] (const mof::tstring& path) { return ::getTextureResourceManager(::SYSTEM)->getResource(path);}
			)
        )
    );
    return pFrame;

}



