#pragma once
#include "GameScene.h"
#include "mof/Graphics.h"
#include "mof/Camera.h"
#include "mof/VertexBuffer.h"
#include "mof/VertexTypes.h"
#include "mof/Billboard.h"
#include "MyWindow.h"
#include "mof/InputReceiver.h"
#include "WorldMapBuilder.h"
#include "mof/Capturer.h"
#include "WorldMapCursor.h"
#include "GameData.h"
#include "mof/SelectionModel.h"
#include "MyFrame.h"
#include "AreaMenu.h"
#include "WorldMenu.h"
#include "World.h"

#include "mof/AnimationScheduler.h"

namespace et{

	class WorldScene
		: public et::GameScene
	{
	
		
		//
		mof::Window* m_pWindow;
		mof::Camera* m_pCamera;
		mof::TextureResource m_pTexture;
		MyFrame* m_pCurrentFrame;
		et::World* m_pWorld;
		mof::AnimationResource m_menuChangeAnimation;
		
		//[hr[
		et::WorldMapBuilder* m_pBuilder;
		et::MapBuffer* m_pWorldMap;
		et::WorldMenu* m_pWorldMenu;
		
		//GAr[
		et::WorldMapCursor* m_pCursor;
		mof::SoftVertexBuffer<mof::VertexXYZC>* m_pGrid;
		mof::SoftVertexBuffer<mof::VertexXYZC>* m_pPoint;
		et::AreaMenu* m_pAreaMenu;

		mof::AnimationScheduler m_translationScheduler;


		mof::Sprite* m_pFeedEffect;
		
	public:
		WorldScene();
		virtual ~WorldScene(void);

		

		virtual bool initialize();
		virtual bool draw();
		virtual bool update();
		

	};

};
