#include "WorldMapCursor.h"
#include "mof/KeyFrameAnimation.h"
#include "mof/ConsoleIO.h"


et::WorldMapCursor::WorldMapCursor(mof::Component3D* pBody)
: Symbol(pBody , 0.05f)
{
	mof::KeyFrameAnimation* pKeyFrameAnimation = new mof::KeyFrameAnimation(true);
	for(int i = 0 ; i < 120 ; i++){
		float angle = 2 * 3.14f / (float)120 * (float)i;
		pKeyFrameAnimation->setRotation(i , mof::Vector3D(0.0f , angle , 0.0f));
	}
	setAnimation( 1 , mof::AnimationResource(pKeyFrameAnimation));
}

et::WorldMapCursor::~WorldMapCursor(void)
{
}


void et::WorldMapCursor::move(Direction direction ,  mof::Vector3D& position , int length)
{
	m_direction = direction;
	mof::AnimationResource pAnimation = getAnimation(3);
	if(pAnimation.get() != NULL && !pAnimation->isFinalized())return;
	
	mof::Vector3D current = getPosition();
	mof::KeyFrameAnimation* pKeyFrameAnimation = new mof::KeyFrameAnimation();
	pKeyFrameAnimation->setPosition(0 , current);
	pKeyFrameAnimation->setPosition(length , position);

	setAnimation( 3 , mof::AnimationResource(pKeyFrameAnimation));
	
}


bool et::WorldMapCursor::isTraveling(){
	return (getAnimationSet()->getElement(3).get() != NULL && !getAnimationSet()->getElement(3)->isFinalized());
}