#pragma once
#include "BattlerFacade.h"
#include "BattlerType.h"
#include "BattleData.h"

namespace et{
	class Action;
	class GameData;

	class FixedBattler : public BattlerFacade
	{
		GameData* m_pGameData;
		BattleAction m_command;
	public:

		FixedBattler(BattlerType type , et::BattlerParameter& parameter , mof::TextureManager* pTextureManager , GameData* pGameData = NULL);
		
		virtual mof::AnimationResource setMovingAnimation(mof::Vector3D& goal , int nFrame);
		virtual mof::AnimationResource setAidlingAnimation(mof::Vector3D& position);
		virtual mof::AnimationResource setCastAnimation(int category);
		virtual mof::AnimationResource setDamagedAnimation(int level);
		virtual Action* createAction(BattlerGroup* pGroup ) ;

		void setBattleCommand(BattleAction& action);
	};


}

