#include "configure.hpp"
#include "mof/Application.hpp"
#include "mof/streams.hpp"
#include "mof/Color.hpp"
#include <exception>
#include <stdexcept>
#include "mof/utilities.hpp"
#include "mof/ConsoleIO.hpp"
#include <conio.h>
#include "mof/Font.hpp"

#include "Demo3.hpp"
#include "Settings.hpp"





int main(int argc, char** argv)
{
#if defined(DEBUG) | defined(_DEBUG)
    _CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif
	std::vector<mof::tstring> args(argv, argv + argc);

	::Settings settings;
	int result = ::LoadSettings(&settings);
	try {
		if (!result) throw std::runtime_error("bad settings");
    	if (!mof::Font::addFontResource( FONT_PATH_UME )) {
			throw std::runtime_error(mof::tstring(_T("failed to addFontResource")) + FONT_PATH_UME);
		}
    	if (!mof::Font::addFontResource( FONT_PATH_CB )) {
			throw std::runtime_error(mof::tstring(_T("failed to addFontResource")) + FONT_PATH_CB);
		}
		if (!mof::Font::addFontResource( FONT_PATH_VINQUE )) {
			throw std::runtime_error(mof::tstring(_T("failed to addFontResource")) + FONT_PATH_VINQUE);
		}



	    { // AvP[V̏
			int upf = settings.fps == 30 ? 2 : 1;
		    mof::Application::initialize
		    (
		        _T("Đ̃TNV[hv1.0") ,
		        settings.screen.width, settings.screen.height,
				settings.screen_mode, settings.fps, upf,
				(mof::Application::InputMode)settings.input_mode, 
				settings.enable_output_frame? true: false,
				settings.enable_output_audio? true: false
		    ); 
		}
		
		my_scene scene(args);
		mof::Application::run(scene);
	}
	catch(std::exception& e) {
		MessageBox(NULL, e.what(), "O܂", MB_OK);
	}
	mof::Application::finalize();

	return 0;
}
