#include <windows.h>
#include <iostream>
#include <cstring>
#include <sqlite3.h>
#include "Settings.hpp"
#include <memory>
#include <boost/lexical_cast.hpp>
#include <boost/format.hpp>
#include <mof/GraphicsDevice.hpp>

namespace 
{
	sqlite3* db;
}

//{{{ callback_load_settings
static int callback_load_settings(void* data, int argc, char** argv, char** colnames)
{
	Settings* settings = static_cast<Settings*>(data);
	for (int i = 0 ; i < argc; i++) {
		char* colname = colnames[i];	
		char* value = argv[i];	
		if (!strcmp(colname, "screen_width")) settings->screen.width = boost::lexical_cast<int>(value);
		else if (!strcmp(colname, "screen_height")) settings->screen.height = boost::lexical_cast<int>(value);
		else if (!strcmp(colname, "screen_mode")) settings->screen_mode = boost::lexical_cast<int>(value);
		else if (!strcmp(colname, "input_mode")) settings->input_mode = boost::lexical_cast<int>(value);
		else if (!strcmp(colname, "enable_output_frame")) settings->enable_output_frame = boost::lexical_cast<int>(value);
		else if (!strcmp(colname, "enable_output_audio")) settings->enable_output_audio = boost::lexical_cast<int>(value);
		else if (!strcmp(colname, "fps")) settings->fps = boost::lexical_cast<int>(value);
	}
	return 0;
}
//}}}
//{{{ LoadSettings
int LoadSettings(Settings* p)
{
	int result;
	sqlite3* db;
	result = sqlite3_open("settings.db", &db);
	if (SQLITE_OK != result) return 0;
	static const char* sql = "SELECT * FROM settings WHERE id = 1";
	char *err;
	result = sqlite3_exec(db, sql, callback_load_settings, (void*)p, &err);
	if (err) {
		std::cout << err << std::endl;
		free(err);
	}
	sqlite3_close(db);
	if (SQLITE_OK != result) return 0;
	return 1;
}
//}}}
