#pragma once
#include <memory>
#include <mof/widget/Layout.hpp>

namespace mof
{
namespace widget
{

	class flow_layout : public Layout
    {

	public:
		enum xalign
        {
			XALIGN_LEFT,
			XALIGN_CENTER,
			XALIGN_RIGHT,
		};
		enum yalign
        {
			YALIGN_TOP,
			YALIGN_CENTER,
			YALIGN_BOTTOM,
		};

		flow_layout(xalign xa, yalign ya, size_t w, size_t h);
		virtual ~flow_layout();
		virtual void add(std::shared_ptr<WidgetView> pView);
        virtual Vector2D getPreferredSize() const;
        virtual void connect(WidgetView* pParentView);
        virtual size_t getLength( ) const;
        virtual int getAdjacencyAsUp(int index) const;
        virtual int getAdjacencyAsDown(int index) const;
        virtual int getAdjacencyAsLeft(int index) const;
        virtual int getAdjacencyAsRight(int index) const;

    private:
        struct impl;
		std::unique_ptr<impl> pimpl_;
	};

}// namepsace widget
}// namepsace mof

