#pragma once
#include "mof/widget/WidgetView.hpp"
#include <memory>

namespace mof
{
    class Font;

namespace widget
{

    class RectangleView 
    : 
        public WidgetView
    {
    public:
    	RectangleView(const mof::Vector2D& scale, mof::Color color);
    	virtual ~RectangleView( );

        virtual FrameNumber show( bool imidiately = false );
        virtual FrameNumber hide( bool imidiately = false );
        virtual FrameNumber focus( bool imidiately = false );
        virtual FrameNumber blur( bool imidiately = false );
        virtual FrameNumber click( bool imidiately = false );
        virtual mof::Vector2D getPreferredSize() const;
        virtual void update( );
        virtual void draw( ) const;
        virtual void setVisible(bool visible);

    private:
        struct Impl;
    	std::unique_ptr<Impl> pImpl_;
    };

}// namespace widget
}// namespace mof

