#include <mof/widget/RectangleView.hpp>
#include "mof/mofGraphics.hpp"
#include "mof/Font.hpp"
#include "mof/utilities.hpp"
#include "mof/widgets.hpp"
#include "mof/streams.hpp"
    
namespace mof
{
namespace widget
{
//{{{ struct Impl
    struct RectangleView::Impl
    {
		mof::Vector2D preferredSize_;
		bool visible_;
    
        Impl( )
			: visible_(true)
        {
        }
    
        ~Impl()
        {
        }
    
    };
//}}}
//{{{ constructor
    RectangleView::RectangleView(const mof::Vector2D& scale, mof::Color color)
    : 
        pImpl_( new Impl ) 
    {
		pImpl_->preferredSize_ = scale;
		m_sizeStream << scale;
		m_colorStream << mof::Color4f(color);
    }
//}}}
//{{{ destructor
    RectangleView::~RectangleView()
    {
    }
//}}}
//{{{ update
    void RectangleView::update( )
    {
        m_positionStream.update( );
        m_sizeStream.update( );
        m_colorStream.update( );
    }
//}}}
//{{{ draw
    void RectangleView::draw( ) const
	{
		if (!pImpl_->visible_) return;
		static VertexXYZRHWC vertices[4];
	
	    Color color = m_colorStream.value( ).toColorCode( );
        
        Vector2D position = m_positionStream.value( );
        Vector2D size = m_sizeStream.value( );
        Vector2D begin = Vector2D( position.x , position.y );
	    Vector2D end = begin + Vector2D( size.x , size.y );
        
        vertices[0].x = static_cast<float>(begin.x);
	    vertices[0].y = static_cast<float>(begin.y);
	    vertices[0].z = 0;
	    vertices[0].rhw = 1;
	    vertices[0].color = color;

	    vertices[1].x = static_cast<float>(end.x);
	    vertices[1].y = static_cast<float>(begin.y);
	    vertices[1].z = 0;
	    vertices[1].rhw = 1;
	    vertices[1].color = color;

	    vertices[2].x = static_cast<float>(begin.x);
    	vertices[2].y = static_cast<float>(end.y);
    	vertices[2].z = 0;
    	vertices[2].rhw = 1;
    	vertices[2].color = color;

    	vertices[3].x = static_cast<float>(end.x);
    	vertices[3].y = static_cast<float>(end.y);
    	vertices[3].z = 0;
    	vertices[3].rhw = 1;
	    vertices[3].color = color;

    	GraphicsDevice::setTexture(NULL);
    	GraphicsDevice::drawVertexArray(vertices[0] , vertices[3] , PRIMITIVE_TYPE_TRIANGLESTRIP);
        
    }
//}}}
//{{{ setVisible
    void RectangleView::setVisible(bool visible)
	{
		pImpl_->visible_ = visible;
    }
//}}}
//{{{ show
    FrameNumber RectangleView::show(bool) 
    {
        return 0;
    }
//}}}
//{{{ hide
    FrameNumber RectangleView::hide(bool)
    {
        return 0;
    }
//}}}
//{{{ focus
    FrameNumber RectangleView::focus(bool) 
    {
        return 0;
    }
//}}}
//{{{ blur
    FrameNumber RectangleView::blur(bool imidiately)
    {
        return 0;
    }
//}}}
//{{{ click
    FrameNumber RectangleView::click(bool)
    {
        return 0;
    }
//}}}
//{{{ click
	mof::Vector2D RectangleView::getPreferredSize() const
    {
        return pImpl_->preferredSize_;
    }
//}}}
}
} // namespace mof
