#pragma once
#include "mof/widget/Container.hpp"
#include <memory>

namespace mof
{
    class Font;

namespace widget
{

    class ClippingView
    : 
        public WidgetView
    {
    public:
        
        ClippingView
        (
            std::shared_ptr<WidgetView> body
        );
    	virtual ~ClippingView( );

        virtual void update( );
        virtual void draw( ) const;
        virtual void setVisible(bool visible);

        virtual FrameNumber show( bool imidiately = false ); 
        virtual FrameNumber hide( bool imidiately = false );
        virtual FrameNumber focus( bool imidiately = false ); 
        virtual FrameNumber blur( bool imidiately = false );
        virtual FrameNumber click( bool imidiately = false );
		virtual mof::Vector2D getPreferredSize() const;

        const std::shared_ptr<WidgetView> getBody() const;
        std::shared_ptr<WidgetView> getBody();
    private:
        struct Impl;
		std::unique_ptr<Impl> pImpl_;
	
    };

}
}
