#pragma once
#include "mof/stream/Manipulator.hpp"
#include "mof/stream/TypeStream.hpp"
#include "mof/Vector2D.hpp"
#include "mof/Vector3D.hpp"
#include "mof/Matrix2D.hpp"
#include "mof/Matrix3D.hpp"
#include "mof/Color.hpp"
#include "mof/Rectangle.hpp"

namespace mof
{
    typedef TypeStream< Vector2D , Add< Vector2D > > Vector2DStream;
    typedef TypeStream< Vector3D , Add< Vector3D > > Vector3DStream;
    typedef TypeStream<Matrix3D, Multiply<Matrix3D>> Matrix3DStream;
    typedef TypeStream< Color4f , Multiply< Color4f > > ColorStream;
    typedef TypeStream< Rectangle< float > , Overwrite< Rectangle<float> > > RectangleStream;

    Manipulator< Vector2D >::Handler 
    makeTranslation2DHandler( const Manipulator< Matrix2D >::Handler& handler );

    Manipulator< Vector2D >::Handler 
    makeScaling2DHandler( const Manipulator< Matrix2D >::Handler& handler );

    Manipulator< Vector2D >::Handler 
    makeRotation2DHandler( const Manipulator< Matrix2D >::Handler& handler );


} // namespace mof
