#include "mof/stream/utilities.hpp"
#include "mof/stream/Joint.hpp"
#include <boost/bind.hpp>

namespace
{
    mof::Vector2D matrix2translation( const mof::Matrix2D& matrix )
    {
        return mof::Matrix2D::getTranslation( matrix );
    }
    
    mof::Vector2D matrix2scaling( const mof::Matrix2D& matrix )
    {
        return matrix.getDiagonal( );
    }

    mof::Vector2D matrix2rotation( const mof::Matrix2D& matrix )
    {
        //TODO implementation
        return matrix.getDiagonal( );
    }

}


namespace mof
{

    Manipulator< Vector2D >::Handler 
    makeTranslation2DHandler( const Manipulator< Matrix2D >::Handler& handler )
    {
        return makeJointHandler( handler , &matrix2translation );
        //return makeJointHandler( handler , boost::bind( &matrix2translation ) );
    }

    Manipulator< Vector2D >::Handler 
    makeScaling2DHandler( const Manipulator< Matrix2D >::Handler& handler )
    {
        return makeJointHandler( handler , &matrix2scaling );
        //return makeJointHandler( handler , boost::bind( &matrix2scaling ) );
    }


    Manipulator< Vector2D >::Handler 
    makeRotation2DHandler( const Manipulator< Matrix2D >::Handler& handler )
    {
        return makeJointHandler( handler , &matrix2rotation  );
        //return makeJointHandler( handler , boost::bind( &matrix2rotation )  );
    }



} // namespace mof

