#pragma once
#include "mof/stream/Manipulator.hpp"

namespace mof
{
	template< typename T >
	class Minimum : public Manipulator< T >
    {
	public:
		typedef typename std::shared_ptr< mof::Minimum<T> > Handler;

		Minimum() {}
        
        virtual ~Minimum() {}

		virtual T value( FrameNumber frame ) const
        {
			T min;
			if(list_.empty())return min;
			min = list_.at(0)->value(frame);
			for (size_t i = 1; i < list_.size(); ++i)
			{
				T current = list_.at(i)->value(frame);
				if (min > current)min = current;
			}
            return min;
        }

        
        const std::vector<Handler>& getList( ) const { return list_; }

        void add( const typename Handler& handler ){ list_.push_back(handler); }

    private:
		std::vector<Handler> list_;

	}; // class Minimum


} // namespace mof
