#include "mof/sound/StreamingSoundLoader.hpp"
#include "mof/ConsoleIO.hpp"


mof::StreamingSoundLoader::StreamingSoundLoader(LPDIRECTSOUNDBUFFER8 pBuffer , LPDIRECTSOUNDNOTIFY8 pNotify , SoundFile* pResource){
	m_pBuffer = pBuffer;
	DSBCAPS caps;
	ZeroMemory(&caps, sizeof(DSBCAPS));
	caps.dwSize = sizeof(DSBCAPS);
	m_pBuffer->GetCaps(&caps);
	m_bufferSize = caps.dwBufferBytes;
	m_pNotify = pNotify;
	m_hEvents = NULL;
	m_pResource = pResource;
}

mof::StreamingSoundLoader::StreamingSoundLoader(const StreamingSoundLoader& obj){

	m_pBuffer = obj.m_pBuffer;
	m_bufferSize = obj.m_bufferSize;
	m_hEvents = NULL;
	m_pNotify = obj.m_pNotify;
	initialize();
	
}

mof::StreamingSoundLoader::~StreamingSoundLoader(void)
{
	for(int i = 0 ; i < 3 ; i++)CloseHandle(m_hEvents[i]);
	delete m_hEvents;
}

bool mof::StreamingSoundLoader::initialize(){

	m_hEvents = new HANDLE[3];
	for(int i = 0 ; i < 3 ; i++){
		m_hEvents[i] = CreateEvent(NULL , FALSE , FALSE , NULL);
	}

	DSBPOSITIONNOTIFY pn[3];
	pn[0].dwOffset = 0;
	pn[0].hEventNotify = m_hEvents[0];
	pn[1].dwOffset = m_bufferSize / 2;
	pn[1].hEventNotify = m_hEvents[1];
	pn[2].dwOffset = DSBPN_OFFSETSTOP;
	pn[2].hEventNotify = m_hEvents[2];


	HRESULT hr = m_pNotify->SetNotificationPositions(3 , pn);
	if(FAILED(hr)){
		if(hr == DSERR_INVALIDPARAM)*ConsoleOut::getInstance() << m_pNotify << std::endl;
		*ConsoleOut::getInstance() << "Failed --- SetNotificationPosition" << std::endl;
		return false;
	}
	//CopyBlock(1);
	return true;

}




void mof::StreamingSoundLoader::operator()(){
	copyBlock(0);
	
	while(true){
		DWORD i = WaitForMultipleObjects(3 , m_hEvents , FALSE , INFINITE);
		//m_pBuffer->GetCurrentPosition(
		switch(i){
			case WAIT_OBJECT_0:
				copyBlock(1);
				break;
			case WAIT_OBJECT_0 + 1:
				copyBlock(0);
				break;
			case WAIT_OBJECT_0 + 2:
				return;
		}

	}


	return;

}


void mof::StreamingSoundLoader::copyBlock(int blockID){
	boost::mutex::scoped_lock lock(m_mutex);
	HRESULT hr;
	long updateSize = m_bufferSize / 2;

	LPVOID pMem1 , pMem2;
	DWORD dwSize1 , dwSize2;
	//*ConsoleOut::getInstance() << blockID << "XV" << std::endl;
	hr = m_pBuffer->Lock(blockID * updateSize , updateSize , &pMem1 , &dwSize1 , &pMem2 , &dwSize2 , 0);
	if(FAILED(hr)){
		*ConsoleOut::getInstance() << _T("Failed --- LockSoundBuffer") << std::endl;
		return;
	}
	
	m_pResource->read((BYTE*)pMem1 , dwSize1 , (BYTE*)pMem2 , dwSize2);
	m_pBuffer->Unlock(pMem1 , dwSize1 , pMem2 , dwSize2);
}

