#include <mof/multi_solid.hpp>
#include <mof/utilities.hpp>
#include <vector>

namespace mof
{
//{{{ impl
	struct multi_solid::impl
	{
		std::vector<Graphics3D::ptr> children_;

		impl()
		{
		}

		~impl()
		{
		}
	};
//}}}
//{{{ constructor
	multi_solid::multi_solid(const Graphics3D::ptr& front, const Graphics3D::ptr& back)
		: pimpl_(new impl())
	{
		size_t len = std::distance(&front, &back) + 1;
		pimpl_->children_.reserve(len);
		for (size_t i = 0; i < len; ++i) {
			pimpl_->children_.push_back((&front)[i]);
			pimpl_->children_[i]->world_transform() << world_transform();
		}

	}
//}}}
//{{{ destructor
	multi_solid::~multi_solid()
	{
	}
//}}}
//{{{ update
	void multi_solid::update()
	{
		world_transform_.update();
		foreach (auto& p, pimpl_->children_) {
			p->update();
		}
	}
//}}}
//{{{ draw
	void multi_solid::draw() const
	{
		foreach (auto& p, pimpl_->children_) {
			p->draw();
		}
	}
//}}}
//{{{ setTexture
	void multi_solid::setTexture
	( 
		unsigned int num,
		const std::shared_ptr<mof::Texture>& pTexture
	)
	{
		foreach (auto& p, pimpl_->children_) {
			p->setTexture(num, pTexture);
		}
	}
//}}}
//{{{ setMaterialBuilder
	/*
	void multi_solid::setMaterialBuilder
	( 
		unsigned int num,
		const std::shared_ptr<mof::MaterialBuilder>& material_builder
	)
	{
		foreach (auto& p, pimpl_->children_) {
			p->setMaterialBuilder(num, material_builder);
		}
	}
	*/
//}}}
//{{{ setVisible
	void multi_solid::setVisible(bool visible)
	{
		foreach (auto& p, pimpl_->children_) {
			p->setVisible(visible);
		}
	}
//}}}
//{{{ child
	Graphics3D::ptr multi_solid::child(size_t index)
	{
		return pimpl_->children_.at(index);
	}
//}}}
}// namespace mof
