
#include "mof/Vector2D.hpp"

mof::Vector2D::Vector2D(real x_ , real y_)
: x(x_) , y(y_)
{}

mof::Vector2D::Vector2D(int x_ , int y_)
: x(mof::int2real(x_)) , y(mof::int2real(y_))
{}


mof::Vector2D::Vector2D(){
	x = y = 0;
}

mof::Vector2D::~Vector2D(void)
{
}


bool mof::Vector2D::operator == (const mof::Vector2D& obj) const{
	if(x == obj.x && y == obj.y)return true;
	else return false;
}

bool mof::Vector2D::operator != (const mof::Vector2D& obj) const{
	return !(*this == obj);
}
	
mof::Vector2D mof::Vector2D::operator - () const{
	return mof::Vector2D( -x , -y);
}
	


mof::Vector2D mof::Vector2D::operator +( const mof::Vector2D& rhs) const{
	return mof::Vector2D(this->x + rhs.x , this->y + rhs.y);
}


mof::Vector2D mof::Vector2D::operator -( const mof::Vector2D& rhs) const{
	return mof::Vector2D(this->x - rhs.x , this->y - rhs.y);
}
		
mof::Vector2D mof::Vector2D::operator *(float rhs) const{
	return mof::Vector2D(this->x * rhs , this->y * rhs);
}


mof::Vector2D mof::Vector2D::operator /(float rhs) const{
	return mof::Vector2D(this->x / rhs , this->y / rhs);
}


mof::Vector2D mof::operator *(const mof::Vector2D& vec , float f){
	mof::Vector2D obj;
	obj.x = vec.x * f;
	obj.y = vec.y * f;
	return obj;
}
	
mof::Vector2D mof::operator *(float f , const mof::Vector2D& vec ){
	mof::Vector2D obj;
	obj.x = vec.x * f;
	obj.y = vec.y * f;
	return obj;
}

std::ostream& mof::operator <<(std::ostream& os , const mof::Vector2D& obj)
{
	os << '(' << obj.x << ',' << obj.y << ')';
	return os;	
}

