#ifndef MOF_MATERIAL_HPP
#define MOF_MATERIAL_HPP
#include "Color.hpp"

namespace mof{

struct Material{
	mof::Color4f diffuseColor;
	mof::Color4f ambientColor;
	mof::Color4f specularColor;
	float power;
	mof::Color4f emissiveColor;

	Material()
		: ambientColor(0 , 0 , 0) , 
		  diffuseColor(0 , 0 , 0) ,
		  specularColor(0 , 0 , 0),
		  power(0),
		  emissiveColor(0 , 0 , 0)
	{
		
	}

	Material(
		mof::Color4f ambient_ ,
		mof::Color4f diffuse_ ,
		mof::Color4f specular_ ,
		real power_ ,
		mof::Color4f emissive_
		)
		: ambientColor(ambient_) , 
		  diffuseColor(diffuse_) ,
		  specularColor(specular_),
		  power(power_),
		  emissiveColor(emissive_)
	{
		
	}


};

}

#endif
