#include "mof/private/DirectInput.hpp"
#include "mof/private/DeviceInputReceiver.hpp"
#include "mof/InputDevice.hpp"
#include "mof/ConsoleIO.hpp"
#include "mof/InputEventCondition.hpp"


mof::DeviceInputReceiver::DeviceInputReceiver()
: mof::InputReceiver(){
	m_pKeyStates = new bool[mof::DeviceInputReceiver::END];
	for(int i = 0 ; i < mof::DeviceInputReceiver::END ; i++)m_pKeyStates[i] = false;
}

mof::DeviceInputReceiver::~DeviceInputReceiver(){
	delete[] m_pKeyStates;
	
}

bool mof::DeviceInputReceiver::testKeyState(mof::InputReceiver::Key key){

	return m_pKeyStates[key];
	
}

void mof::DeviceInputReceiver::update(){
	mof::InputDevice::update();
}


void mof::DeviceInputReceiver::notifyInputEvent(mof::InputEvent& inputEvent){
	mof::DeviceInputReceiver::Key key;

    
	switch(inputEvent.dwOfs){
		case DIK_UP :
			key = mof::DeviceInputReceiver::UP;
			break;
		case DIK_DOWN :
			key = mof::DeviceInputReceiver::DOWN;
			break;
		case DIK_LEFT :
			key = mof::DeviceInputReceiver::LEFT;
			break;
		case DIK_RIGHT :
			key = mof::DeviceInputReceiver::RIGHT;
			break;
        case DIK_A :
			key = mof::DeviceInputReceiver::A;
			break;
        case DIK_B :
			key = mof::DeviceInputReceiver::B;
			break;
        case DIK_C :
			key = mof::DeviceInputReceiver::C;
			break;
        case DIK_D :
			key = mof::DeviceInputReceiver::D;
			break;
        case DIK_E :
			key = mof::DeviceInputReceiver::E;
			break;
        case DIK_F :
			key = mof::DeviceInputReceiver::F;
			break;
        case DIK_G :
			key = mof::DeviceInputReceiver::G;
			break;
        case DIK_H :
			key = mof::DeviceInputReceiver::H;
			break;
        case DIK_I :
			key = mof::DeviceInputReceiver::I;
			break;
        case DIK_J :
			key = mof::DeviceInputReceiver::J;
			break;
        case DIK_K :
			key = mof::DeviceInputReceiver::K;
			break;
        case DIK_L :
			key = mof::DeviceInputReceiver::L;
			break;
        case DIK_M :
			key = mof::DeviceInputReceiver::M;
			break;
        case DIK_N :
			key = mof::DeviceInputReceiver::N;
			break;
        case DIK_O :
			key = mof::DeviceInputReceiver::O;
			break;
        case DIK_P :
			key = mof::DeviceInputReceiver::P;
			break;
        case DIK_Q :
			key = mof::DeviceInputReceiver::Q;
			break;
        case DIK_R :
			key = mof::DeviceInputReceiver::R;
			break;
        case DIK_S :
			key = mof::DeviceInputReceiver::S;
			break;
        case DIK_T :
			key = mof::DeviceInputReceiver::T;
			break;
        case DIK_U :
			key = mof::DeviceInputReceiver::U;
			break;
        case DIK_V :
			key = mof::DeviceInputReceiver::V;
			break;
        case DIK_W :
			key = mof::DeviceInputReceiver::W;
			break;
        case DIK_X :
			key = mof::DeviceInputReceiver::X;
			break;
        case DIK_Y :
			key = mof::DeviceInputReceiver::Y;
			break;
        case DIK_Z :
			key = mof::DeviceInputReceiver::Z;
			break;
		case DIK_ESCAPE :
			key = mof::DeviceInputReceiver::ESCAPE;
			break;
		default : 
            return;
	}
	m_pKeyStates[key] = (inputEvent.dwData & 0x80) != 0;
	m_pKeyStates[mof::DeviceInputReceiver::ANY] = (inputEvent.dwData & 0x80) != 0;
	
}
