/*
 * $Id: expatJP.h,v 1.2 2003/11/27 05:54:45 sugoroku Exp $
 * expatShift_JISEUC-JPɑΉ
 * ISO-2022JPɂΉƂ낾expat̎
 */

#ifndef _YEBISUYA_EXPATJP_H_
#define _YEBISUYA_EXPATJP_H_

#include <expat.h>

//#pragma comment(lib, "expatJP.lib")
#ifdef __cplusplus
extern "C" {
#endif

/**
 * UTF8̕EUC-JPɕϊB
 * @param utf8     UTF8̕
 * @param utf8len  ̒B-1w肷ƏI[܂łϊB
 * @param eucjp    EUC-JPɕϊi[obt@B
 * @param eucjplen obt@̒B0w肷Ǝۂɂ͕ϊs킸Aϊ̕񒷂擾B
 * @return ϊ̕񒷁B
 */
int UTF8toEUCJP(const char* utf8, int utf8len, char* eucjp, int eucjplen);

/**
 * UTF8̕SHIFT_JISɕϊB
 * @param utf8	UTF8̕
 * @param utf8len	̒B-1w肷ƏI[܂łϊB
 * @param sjis	SHIFT_JISɕϊi[obt@B
 * @param sjislen	obt@̒B0w肷Ǝۂɂ͕ϊs킸Aϊ̕񒷂擾B
 * @return ϊ̕񒷁B
 */
int UTF8toSJIS(const char* utf8, int utf8len, char* sjis, int sjislen);

/**
 * {ꕶR[h(EUC-JPSHIFT_JIŜ)邽߂̃nh
 * @param encodingHandlerData ̃nĥ߂̃[U`f[^(gp)
 * @param name R[h(̃nhłSHIFT_JISEUC-JP̂ݑΉ)
 * @param info R[hϊ̂߂̏
 * @return ̃nhŏŝłΔ0B
 */
int XML_JapaneseEncodingHandler(void *encodingHandlerData, const XML_Char *name, XML_Encoding *info);

#ifdef __cplusplus
}
#endif


#if 0 //sample

void printUTF8(FILE* fp, const XML_Char* string) {
	int sjislen = UTF8toSJIS(string, -1, NULL, 0);
	char* sjis = (char*) alloca(sjislen);
	UTF8toSJIS(string, -1, sjis, sjislen);
	fputs(sjis, fp);
}

void startElementHandler(void* userData, const XML_Char* name, const XML_Char** atts) {
	fputs(stdout, "start element(tag name: ");
	printUTF8(stdout, name);
	fputs(stdout, ")\n");
	if (atts != NULL) {
		while (*atts != NULL) {
			fputs(stdout, "  attribute(name: ");
			printUTF8(stdout, *atts++);
			fputs(stdout, ", value: \n");
			printUTF8(stdout, *atts++);
			fputs(stdout, ")\n");
		}
	}
}

void endElementHandler(void* userData, const XML_Char* name) {
	int sjislen = UTF8toSJIS(name, -1, NULL, 0);
	char* sjis = (char*) alloca(sjislen);
	UTF8toSJIS(name, -1, sjis, sjislen);
	printf("end element(tag name: %s)\n", sjis)
}

void parseString(const char* string) {
	XML_Parser parser = XML_ParserCreate(NULL);
	XML_SetUnknownEncodingHandler(parser, XML_JapaneseEncodingHandler, NULL);
	XML_SetElementHandler(parser, startElementHandler, endElementHandler);
	XML_Parse(string, strlen(string), true);
}

#endif

#endif//_YEBISUYA_EXPATJP_H_

/*
 * Changes:
 * $Log: expatJP.h,v $
 * Revision 1.2  2003/11/27 05:54:45  sugoroku
 * CVSL[[hRgɑ}
 *
 */
