#include "world/DungeonBuilder.hpp"


DungeonBuilder::DungeonBuilder(mof::PixelMap& map, float scale)
: MapBuilder(scale , map.size() , map[0].size() ) , m_map(map) 
{
	m_blockWidth = map.size();
	m_blockHeight = map[0].size();
}

DungeonBuilder::~DungeonBuilder(void)
{
}

void DungeonBuilder::setBlockSize(int width , int height){
	m_blockWidth = width;
	m_blockHeight = height;
}



std::vector<VertexTypeDungeon> DungeonBuilder::createBlock(int _x , int _y){

	int beginX = _x * m_blockWidth;
	int endX = (_x+1) * m_blockWidth;
	if (endX > m_map.size()) endX = m_map.size();
	int beginY = _y * m_blockHeight;
	int endY = (_y+1) * m_blockHeight;
	if (endY > m_map[0].size()) endY = m_map[0].size();

	std::vector<VertexTypeDungeon> vertices;
	
	for(int x = beginX ; x < endX ; x++){
		for(int y = beginY ; y < endY ; y++){
			addParts(vertices , x , y);
		}
	}

	return vertices;
}


