#pragma once
#include "mof/widget/WidgetView.hpp"
#include "mof/FactoryMethod.hpp"
#include "mof/graphics/utilities.hpp"
#include "mof/widget/utilities.hpp"
#include <boost/scoped_ptr.hpp>
#include <boost/function.hpp>

using mof::widget::WidgetView;

class HighlightButtonView 
: 
    public WidgetView
{
public:
	HighlightButtonView(const boost::function<WidgetView*(void)>& child, bool is_disable_item);
	virtual ~HighlightButtonView( );

    virtual mof::FrameNumber show( bool imidiately = false );
    virtual mof::FrameNumber hide( bool imidiately = false );
    virtual mof::FrameNumber focus( bool imidiately = false );
    virtual mof::FrameNumber blur( bool imidiately = false );
    virtual mof::FrameNumber click( bool imidiately = false );
	virtual mof::Vector2D getPreferredSize() const;
    virtual void update( );
    virtual void draw( ) const;
    virtual void setVisible(bool visible);

private:
    struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;
	
};

